/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.monster.db.DBServer;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.monster.db.MonsterLoadCLI;
import com.entitystream.monster.db.NoDatabaseException;
import com.entitystream.monster.db.OutputType;
import com.entitystream.monster.db.StopIterationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.thrift.transport.TTransportException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;

public class MonsterCLI
extends MonsterClient
implements Runnable {
    private static boolean interrupted;
    @CommandLine.Option(names={"-h", "--host"}, required=false, description={"Remote host IP or DNS Name"})
    private String host = "localhost";
    @CommandLine.Option(names={"-p", "--port"}, required=false, description={"Remote host port (default 27018)"})
    private int port = 27018;
    @CommandLine.Option(names={"-p2", "--httpport"}, required=false, description={"Remote http host port (default 27019)"})
    private int httpport = 27019;
    @CommandLine.Option(names={"-u", "--user"}, required=false, description={"The username to connect with"})
    private String username;
    @CommandLine.Option(names={"-pw", "--password"}, required=false, description={"The usernames password"})
    private String password;
    @CommandLine.Option(names={"-r", "--run"}, required=false, description={"Run the following command"})
    private String command;
    @CommandLine.Option(names={"-d", "--db"}, required=false, description={"connect the DB"})
    private String db;
    @CommandLine.Option(names={"-s", "--start"}, required=false, description={"Start a server"})
    private boolean deamon = false;
    @CommandLine.Option(names={"-a", "--auth"}, required=false, description={"Authentication settings "})
    private String auth;
    @CommandLine.Option(names={"-c", "--collection"}, required=false, description={"Collection to load"})
    private String collection;
    @CommandLine.Option(names={"-f", "--file"}, required=false, description={"File to load"})
    private String filename;
    @CommandLine.Option(names={"-t", "--recordType"}, required=false, description={"Record Type to load (fuzzy tables only)"})
    private String tableName;
    @CommandLine.Option(names={"-o", "--options"}, required=false, description={"Load options"})
    private String propertiestr;
    @CommandLine.Option(names={"-db", "--dbPath"}, required=false, description={"Path for DB Files (Server only)"})
    private String dbPath;
    @CommandLine.Option(names={"-x", "--script"}, required=false, description={"Run a grr script and exit"})
    private String script;
    @CommandLine.Option(names={"-rs", "--replica"}, required=false, description={"Server replica (Server only)"})
    private String[] replicaSet;
    @CommandLine.Option(names={"-n", "--node"}, required=false, description={"Server replica Node Number (hash distribution)"})
    private int node;
    @CommandLine.Option(names={"-pbp", "--postBatchPipeline"}, required=false, description={"Post Batch Pipeline"})
    private String postBatchPipeline;
    @CommandLine.Option(names={"-plp", "--postLoadPipeline"}, required=false, description={"Post Load Pipeline"})
    private String postLoadPipeline;
    @CommandLine.Option(names={"-?", "--help"}, usageHelp=true, description={"Display this help and exit"})
    private boolean help;
    @CommandLine.Option(names={"-q", "--quiet"}, description={"Be less verbose"})
    private boolean quiet;
    @CommandLine.Option(names={"-v", "--version"}, description={"Report Version"})
    private boolean vers;
    private LineReader lineReader;
    private Queue<String> history = new CircularFifoQueue(10);
    private boolean explain = false;

    public static void main(String ... args) {
        CommandLine.run((Runnable)new MonsterCLI(), (PrintStream)System.err, (String[])args);
    }

    @Override
    public void run() {
        ((MonsterClient)this).quiet = this.quiet;
        if (this.vers) {
            this.quiet = true;
        }
        String subTitle = "CLI";
        String typeit = ", for details type \"show license\"";
        if (this.deamon) {
            subTitle = "Server";
            typeit = "";
        }
        if (this.filename != null) {
            subTitle = "Loader";
            typeit = "";
        }
        if (!this.quiet) {
            System.out.println("                                _            _____  ____  ");
            System.out.println("                               | |          |  __ \\|  _ \\ ");
            System.out.println("      _ __ ___   ___  _ __  ___| |_ ___ _ __| |  | | |_) |");
            System.out.println("     | '_ ` _ \\ / _ \\| '_ \\/ __| __/ _ \\ '__| |  | |  _ < ");
            System.out.println("     | | | | | | (_) | | | \\__ \\ ||  __/ |  | |__| | |_) |");
            System.out.println("     |_| |_| |_|\\___/|_| |_|___/\\__\\___|_|  |_____/|____/   " + subTitle + " Build 119.21.0");
            System.out.println("\n     (c) Robert James Haynes (EntityStream KFT), released under AGPL3 license" + typeit + "\n");
        }
        if (this.vers) {
            System.out.println("\nBuild 119.21.0");
        }
        if (this.deamon) {
            if (this.replicaSet == null || this.replicaSet.length == 0 || this.replicaSet.length == 1 && this.replicaSet[0].equalsIgnoreCase("null")) {
                this.replicaSet = new String[0];
            }
            DBServer.start(this.port, this.httpport, this.auth, this.dbPath, this.replicaSet, this.node);
            return;
        }
        if (this.filename != null) {
            new MonsterLoadCLI(this.host, this.port, this.username, this.password, this.collection, this.db, this.filename, this.tableName, this.propertiestr, this.postBatchPipeline, this.postLoadPipeline, this.quiet, true);
        } else {
            block23: {
                try {
                    this.connect(this.host, this.port, this.username, this.password);
                }
                catch (Exception e) {
                    if (this.quiet) break block23;
                    System.err.println("An error (" + e.toString() + ") occurred, you can continue, but there is nothing useful to do.");
                }
            }
            if (this.db != null) {
                this.useDatabase(this.db);
            }
            if (this.command != null) {
                MonsterCLI.parseCMD(this.command, new PrintWriter(System.out, true), this.history, this.output, this.explain, this, this.quiet, this.lineReader, "");
            } else if (this.script != null) {
                this.parseScript(this.script);
            } else {
                try {
                    Object shPrompt;
                    String cmd;
                    Terminal terminal = TerminalBuilder.builder().system(true).signalHandler(new Terminal.SignalHandler(){

                        public void handle(Terminal.Signal signal) {
                            if (signal.equals((Object)Terminal.Signal.INT)) {
                                System.out.println("Interrupting Stream from Server...");
                                interrupted = true;
                            }
                        }
                    }).build();
                    this.lineReader = LineReaderBuilder.builder().terminal(terminal).build();
                    do {
                        shPrompt = "monsterDB> ";
                        if (this.database == null) continue;
                        shPrompt = this.database + ">";
                    } while ((cmd = this.lineReader.readLine((String)shPrompt)).trim().length() <= 0 || MonsterCLI.parseCMD(cmd, new PrintWriter(System.out, true), this.history, this.output, this.explain, this, this.quiet, this.lineReader, ""));
                }
                catch (Exception e1) {
                    System.err.println(e1.getClass().getSimpleName() + " caused monsterDB to stop.");
                }
                if (!this.quiet) {
                    System.err.println("Grrr...");
                }
            }
            try {
                this.disconnect();
            }
            catch (Exception e) {
                System.err.println("Disconnect failed...");
            }
            if (this.filename == null) {
                System.exit(0);
            }
        }
    }

    private void parseScript(String script) {
        try {
            File file = new File(script);
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                String cmd = "";
                int lc = 0;
                while ((cmd = br.readLine()) != null) {
                    ++lc;
                    if (MonsterCLI.parseCMD(cmd, new PrintWriter(System.out, true), this.history, this.output, this.explain, this, this.quiet, this.lineReader, "")) continue;
                    System.err.println("Grr command failed on line " + lc + ": " + cmd);
                    break;
                }
                br.close();
            } else {
                System.err.println("Grr file not found: " + file.getAbsoluteFile().getPath());
            }
        }
        catch (Exception e) {
            System.err.println("An error (" + e.toString() + ") occurred");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parseCMD(String cmd2, PrintWriter out, Queue<String> history, OutputType output, boolean explain, MonsterClient client, boolean quiet, LineReader lineReader, String delimiter) {
        cmd2 = cmd2.trim();
        String[] cmds = cmd2.split(" ");
        if (!quiet) {
            out.println();
        }
        if (cmds.length <= 0) return true;
        if (cmds[0].equalsIgnoreCase("show")) {
            if (cmds.length <= 1 || !cmds[1].equalsIgnoreCase("license")) return true;
            out.println("    MonsterDB - Collection Based Database with fuzzy matching\n    \n    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary\n\n    This program is free software: you can redistribute it and/or modify\n    it under the terms of the GNU Affero General Public License as\n    published by the Free Software Foundation, either version 3 of the\n    License, or (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU Affero General Public License for more details.\n\n    You should have received a copy of the GNU Affero General Public License\n    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html");
            return true;
        }
        if (cmds[0].equalsIgnoreCase("recall")) {
            if (cmds.length == 1) {
                Iterator it = history.iterator();
                int count = 0;
                while (it.hasNext()) {
                    out.println(++count + ": " + (String)it.next());
                }
                return true;
            } else {
                Iterator it = history.iterator();
                int count = 0;
                while (it.hasNext()) {
                    cmd2 = (String)it.next();
                    if (!("" + ++count).equalsIgnoreCase(cmds[1])) continue;
                    if (quiet) return MonsterCLI.parseCMD(cmd2, out, history, output, explain, client, quiet, lineReader, "");
                    out.println(cmd2);
                    return MonsterCLI.parseCMD(cmd2, out, history, output, explain, client, quiet, lineReader, "");
                }
            }
            return true;
        }
        if (cmd2.equalsIgnoreCase("/")) {
            for (String cmd2 : history) {
            }
            if (quiet) return MonsterCLI.parseCMD(cmd2, out, history, output, explain, client, quiet, lineReader, "");
            out.println(cmd2);
            return MonsterCLI.parseCMD(cmd2, out, history, output, explain, client, quiet, lineReader, "");
        }
        if (cmds[0].equalsIgnoreCase("use")) {
            client.useDatabase(cmds[1]);
            return true;
        }
        if (cmds[0].equalsIgnoreCase("quit")) {
            return false;
        }
        if (cmds[0].equalsIgnoreCase("db")) {
            if (cmds.length == 1) {
                if (quiet) return true;
                out.println(client.currentDatabase());
                return true;
            } else {
                if (client.currentDatabase() != null) {
                    Document argd = new Document();
                    if (cmds[1].equalsIgnoreCase("dropCollection")) {
                        if (cmds.length > 2) {
                            argd.append("1", cmd2.substring("db dropcollection ".length()));
                        }
                    } else if (cmds[1].equalsIgnoreCase("createCollection")) {
                        if (cmds.length > 2) {
                            argd.append("1", cmds[2]);
                        }
                        if (cmds.length > 3) {
                            String remain = cmd2.split(" ", 4)[3];
                            if (remain.startsWith("{")) {
                                argd.append("2", Document.parse(remain));
                            } else {
                                argd.append("2", remain);
                            }
                        }
                    } else if (cmds[1].equalsIgnoreCase("createFuzzyCollection")) {
                        if (cmds.length > 2) {
                            argd.append("1", cmds[2]);
                        }
                        if (cmds.length > 3) {
                            argd.append("2", cmds[3]);
                        }
                        if (cmds.length > 4) {
                            argd.append("3", cmds[4]);
                        }
                        if (cmds.length > 5) {
                            String remain = cmd2.split(" ", 6)[5];
                            if (remain.startsWith("{")) {
                                argd.append("4", Document.parse(remain));
                            } else {
                                argd.append("4", remain);
                            }
                        }
                    } else if (cmds[1].equalsIgnoreCase("loadCollection")) {
                        try {
                            void var21_67;
                            String sargs = "-h::" + client.connection + "::-p::" + client.port + "::-c::" + cmds[2] + "::-d::" + client.database + "::";
                            if (client.username != null) {
                                sargs = sargs + "-u::" + client.username + "::-pw::" + client.password;
                            }
                            ArrayList<Object> args = new ArrayList<Object>();
                            for (String string : sargs.split("::")) {
                                args.add(string);
                            }
                            String[] questions = new String[]{"Filename: ", "Post Batch Pipeline (Enter for None): ", "Post Load Pipeline (Enter for None): ", "Fuzzy Record Type (Enter for None): ", "FileType: ", "XML RootNode: ", "Delimiter: "};
                            String[] shortCodes = new String[]{"-f", "-pb", "-pl", "-r", "fileType", "rootNode", "Delimiter"};
                            Boolean[] mandatory = new Boolean[]{true, false, false, false, false, false, false};
                            Boolean[] booleanArray = new Boolean[]{false, false, false, false, true, true, true};
                            int n = -1;
                            Document options = new Document();
                            String[] stringArray = questions;
                            int n2 = stringArray.length;
                            boolean bl = false;
                            while (var21_67 < n2) {
                                void var17_54;
                                String question = stringArray[var21_67];
                                ++var17_54;
                                String answer = null;
                                boolean first = true;
                                while (mandatory[var17_54].booleanValue() && (answer == null || answer.length() == 0) || first) {
                                    answer = lineReader.readLine(question);
                                    first = false;
                                }
                                if (answer != null && answer.length() != 0) {
                                    if (!booleanArray[var17_54].booleanValue()) {
                                        args.add(shortCodes[var17_54]);
                                        args.add(answer);
                                    } else {
                                        options.append(shortCodes[var17_54], answer);
                                    }
                                }
                                ++var21_67;
                            }
                            if (options.size() > 0) {
                                args.add("-o");
                                args.add("'" + options.toJson() + "'");
                            }
                            if (!quiet) {
                                StringBuilder sb = new StringBuilder();
                                for (String string : args) {
                                    sb.append(" " + string);
                                }
                                System.out.println("Executing: monsterCLI " + sb.toString().trim());
                            }
                            MonsterLoadCLI.main(args.toArray(new String[args.size()]));
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (cmds.length > 2) {
                        for (int t = 2; t < cmds.length; ++t) {
                            if (cmds[t].trim().startsWith("{")) {
                                argd.append("" + (t - 1), Document.parse(cmds[t]));
                                continue;
                            }
                            argd.append("" + (t - 1), cmds[t]);
                        }
                    }
                    if (argd.size() != 0) return MonsterCLI.runCommand(client.currentDatabase(), null, cmds[1], argd, cmd2, null, out, history, output, explain, client, quiet, delimiter);
                    argd = null;
                    return MonsterCLI.runCommand(client.currentDatabase(), null, cmds[1], argd, cmd2, null, out, history, output, explain, client, quiet, delimiter);
                }
                out.println("Use a database first, ie use dbname");
            }
            return true;
        }
        if (cmds[0].equalsIgnoreCase("drop")) {
            if (cmds.length > 1) {
                return MonsterCLI.runCommand(null, null, "dropDatabase", new Document("1", cmds[1]), cmd2, null, out, history, output, explain, client, quiet, delimiter);
            }
            out.println("Supply a database name");
            return true;
        }
        if (cmds[0].equalsIgnoreCase("create")) {
            if (cmds.length > 1) {
                return MonsterCLI.runCommand(null, null, "createDatabase", new Document("1", cmds[1]), cmd2, null, out, history, output, explain, client, quiet, delimiter);
            }
            out.println("Supply a database name");
            return true;
        }
        if (cmds[0].equalsIgnoreCase("disconnect")) {
            if (cmds.length > 1) {
                return MonsterCLI.runCommand(null, null, "disconnect", new Document("1", cmds[1]), cmd2, null, out, history, output, explain, client, quiet, delimiter);
            }
            out.println("Supply a database name");
            return true;
        }
        if (cmds[0].equalsIgnoreCase("set")) {
            if (cmds.length <= 1) return true;
            String what = cmds[1];
            if (cmds.length <= 2) return true;
            String to = cmds[2];
            if (what.equalsIgnoreCase("output")) {
                client.setOutputType(OutputType.parse(to));
                return true;
            }
            if (what.equalsIgnoreCase("quiet")) {
                quiet = Boolean.parseBoolean(to);
                return true;
            }
            if (!what.equalsIgnoreCase("explain")) return true;
            explain = Boolean.parseBoolean(to);
            return MonsterCLI.runCommand(null, null, "setDebug", new Document("1", explain), "setDebug " + explain, null, out, history, output, explain, client, quiet, delimiter);
        }
        if (cmds[0].equalsIgnoreCase("help")) {
            if (cmds.length == 1) {
                out.println("help db\t\t\t\t\t\t-Database help");
                out.println("help collection\t\t\t\t\t-Collection commands help");
                out.println("help dq\t\t\t\t\t\t-Data Quality commands help");
                out.println("help fuzzy\t\t\t\t\t-Fuzzy commands help");
                out.println("set output csv|xml|json|pretty\t\t\t-Set output");
                out.println("set quiet true|false\t\t\t\t-Set quiet mode");
                out.println("set explain true|false\t\t\t\t-Set explain mode");
                out.println("listDatabaseNames\t\t\t\t-List Databases");
                out.println("connect [host] [port] [username] [password]\t-Connect/Reconnect session");
                out.println("use dbname\t\t\t\t\t-Connect to a DB");
                out.println("disconnect dbname\t\t\t\t-Disconnect from a DB");
                out.println("drop dbname\t\t\t\t\t-Drop a DB");
                out.println("create dbname\t\t\t\t\t-Create a new DB");
                out.println("shutdown\t\t\t\t\t-Shutdown the server");
                out.println("quit\t\t\t\t\t\t-Leave");
                return true;
            } else if (cmds[1].equalsIgnoreCase("db")) {
                out.println("db listCollectionNames\t\t\t\t\t\t\t\t-List Collections for current DB");
                out.println("db close\t\t\t\t\t\t\t\t\t-Close current DB");
                out.println("db createCollection name [{Ranges}] | [Hash]\t\t\t\t\t-Create new OPTIONALLY replicated collection");
                out.println("db createFuzzyCollection name definition.json ruleSetDir [{Ranges}] | [Hash]\t-Create a fuzzy collection");
                out.println("db createFuzzyCollection name [{Ranges}] | [Hash]\t\t\t\t-Create a fuzzy capable collection, with no fuzzy rules ");
                out.println("db describeCollection name\t\t\t\t\t\t\t-Describe a collection");
                out.println("db dropCollection name\t\t\t\t\t\t\t\t-Drop a collection");
                out.println("db loadCollection name\t\t\t\t\t\t\t\t-Load a collection from a source (interactive)");
                return true;
            } else if (cmds[1].equalsIgnoreCase("collection")) {
                out.println("db.collectionName.deleteMany({filter: \"value\"})\t\t\t\t\t-Delete Documents matching filter document");
                out.println("db.collectionName.find({filter: \"value\"})\t\t\t\t\t-Find Documents matching filter document");
                out.println("db.collectionName.insertOne({....})\t\t\t\t\t\t-Create new Documents");
                out.println("db.collectionName.save({....})\t\t\t\t\t\t\t-Create new Documents");
                out.println("db.collectionName.createIndex({field: 1/0,...})\t\t\t\t-Create non-unique Index");
                out.println("db.collectionName.createUniqueIndex({field: 1/0,...})\t\t\t\t-Create unique Index");
                return true;
            } else if (cmds[1].equalsIgnoreCase("fuzzy")) {
                out.println("db.collectionName.saveTable({tableName: \"...\", keyField: \"...\", columns: [{ colName: \"...\"}, ...]})\t\t\t\t\t\t-Create or update a record type and specify the optional columns to use");
                out.println("db.collectionName.deleteTable(name)\t\t\t\t\t\t\t\t\t\t\t\t\t\t-Delete a record type");
                out.println("db.collectionName.saveConceptGroup({purposeName: \"...\", purposeType:  \"...\", .... })\t\t\t\t\t\t\t\t-Create or update a concept group (purpose) and its options");
                out.println("db.collectionName.deleteConceptGroup(name)\t\t\t\t\t\t\t\t\t\t\t\t\t-Delete a Concept Group, and its concepts");
                out.println("db.collectionName.saveConcept({ purposeName: \"...\", column:  \"...\", matchClass:  \"...\"})\t\t\t\t\t\t\t-Create or update a concept (Purpose Column) for a group (Purpose) and its options");
                out.println("db.collectionName.deleteConcept(column)\t\t\t\t\t\t\t\t\t\t\t\t\t\t-Delete a Concept (Purpose Column)");
                out.println("db.collectionName.saveConceptMapping({purposeName:  \"...\", purposeColumn:  \"...\",  tableName:  \"...\", tableColumn:  \"...\", columnOrder: 0})\t-Create or update a concept to table mapping");
                out.println("db.collectionName.deleteConceptMapping({purposeName:  \"...\", purposeColumn:  \"...\",  tableName:  \"...\", tableColumn:  \"...\"})\t\t\t-Delete a concept to table mapping");
                out.println("db.collectionName.saveMatchRule({order: 0 ..., rulePurpose: [ purposeName: \"\", ...]})\t\t\t\t\t\t\t\t-Create or update a match rule");
                out.println("db.collectionName.deleteMatchRule(order)\t\t\t\t\t\t\t\t\t\t\t\t\t-Delete a match rule at position denoted by order");
                out.println("db.collectionName.saveFuzzyIndex({indexName: \"...\", purposeName: \"...\", ...))\t\t\t\t\t\t\t\t\t-Create or update a fuzzy index");
                out.println("db.collectionName.deleteFuzzyIndex(name)\t\t\t\t\t\t\t\t\t\t\t\t\t-Delete a fuzzy index");
                out.println("db.collectionName.setAutoMatch(true|false)\t\t\t\t\t\t\t-Swicth on/off automatch (default off)");
                return true;
            } else {
                if (!cmds[1].equalsIgnoreCase("dq")) return true;
                out.println("dq.setRuleSetPath(\"...path...\")\t\t\t\t\t\t\t-Update the DQ rules from the path specified");
                out.println("dq.getRuleSetPath()\t\t\t\t\t\t\t\t-Show the permanent location of the rules (this node)");
                out.println("dq.saveQualityRule({type:  \"...\" , parent:  \"...\", children:  [ \"\", \"\", ...]})\t-Create or update a quality rule");
                out.println("dq.findQualityRules({...filter...})\t\t\t\t\t\t-List quality rules");
                out.println("dq.installRules(list)\t\t\t\t\t\t-Install quality rules, list is comma sep list of rule types or empty");
            }
            return true;
        }
        cmds = cmd2.split("\\.", 3);
        if (cmds.length <= 0) return true;
        if (cmds[0].equalsIgnoreCase("db")) {
            String argString;
            if (client.currentDatabase() == null) {
                out.println("Use a database first, ie use dbname");
                return true;
            }
            if (cmds.length <= 1) return MonsterCLI.runCommand(null, null, cmds[0], null, cmd2, null, out, history, output, explain, client, quiet, delimiter);
            client.useCollection(cmds[1]);
            String nextPart = null;
            if (cmds.length <= 2) return true;
            String command2 = argString = cmds[2];
            if (argString.indexOf("(") != -1) {
                command2 = argString.substring(0, argString.indexOf("("));
                if ((argString = argString.substring(argString.indexOf("(") + 1)).indexOf(")") != -1) {
                    nextPart = argString.substring(argString.indexOf(")") + 1);
                    argString = argString.substring(0, argString.indexOf(")"));
                }
            }
            ArrayList<Object> args = null;
            if (argString.length() != 0) {
                if (argString.trim().startsWith("{") || argString.trim().startsWith("[")) {
                    Object argso = Document.parseListOrDoc(argString);
                    if (argso instanceof String) {
                        out.println("Error: " + (String)argso);
                        return true;
                    }
                    args = (List)argso;
                } else {
                    String[] arganaught = argString.split(",");
                    if (arganaught.length > 0) {
                        void var17_56;
                        args = new ArrayList<Object>();
                        String[] mandatory = arganaught;
                        int n = mandatory.length;
                        boolean bl = false;
                        while (var17_56 < n) {
                            String a = mandatory[var17_56];
                            if (a.trim().startsWith("\"") || a.trim().startsWith("'")) {
                                args.add(a.replaceAll("\\\"|'", "").trim());
                            } else {
                                try {
                                    args.add(Double.parseDouble(a.trim()));
                                }
                                catch (NumberFormatException n3) {
                                    try {
                                        args.add(Boolean.parseBoolean(a.trim()));
                                    }
                                    catch (Exception e) {
                                        args.add(a);
                                    }
                                }
                            }
                            ++var17_56;
                        }
                    }
                }
            }
            if (args != null && args.size() == 0) {
                args = null;
            }
            int count = 0;
            Document argDc = null;
            if (args == null) return MonsterCLI.runCommand(client.currentDatabase(), cmds[1], command2, argDc, cmd2, nextPart, out, history, output, explain, client, quiet, delimiter);
            argDc = new Document();
            for (Object e : args) {
                argDc.put("" + ++count, e);
            }
            return MonsterCLI.runCommand(client.currentDatabase(), cmds[1], command2, argDc, cmd2, nextPart, out, history, output, explain, client, quiet, delimiter);
        }
        if (cmds[0].equalsIgnoreCase("dq")) {
            cmds = cmd2.split("\\.", 2);
            if (cmds.length <= 1) return MonsterCLI.runCommand(null, null, cmds[0], null, cmd2, null, out, history, output, explain, client, quiet, delimiter);
            String command3 = cmds[1].substring(0, cmds[1].indexOf("("));
            String argString = cmds[1].substring(cmds[1].indexOf("(") + 1);
            if (argString.endsWith(")")) {
                argString = argString.substring(0, argString.length() - 1);
            }
            ArrayList<String> args = null;
            if (argString.length() != 0) {
                if (argString.trim().startsWith("{") || argString.trim().startsWith("[")) {
                    Object argso = null;
                    try {
                        argso = Document.parseListOrDocument("[" + argString + "]");
                    }
                    catch (Exception e) {
                        out.println("Error: " + (String)argso);
                        return true;
                    }
                    args = (List)argso;
                } else {
                    String[] arganaught = argString.split(",");
                    if (arganaught.length > 0) {
                        void var16_51;
                        args = new ArrayList<String>();
                        String[] e = arganaught;
                        int n = e.length;
                        boolean bl = false;
                        while (var16_51 < n) {
                            String string = e[var16_51];
                            args.add(string.replaceAll("\\\"|'", ""));
                            ++var16_51;
                        }
                    }
                }
            }
            if (args != null && args.size() == 0) {
                args = null;
            }
            int count = 0;
            Document argDc = null;
            if (args == null) return MonsterCLI.runCommand(null, null, command3, argDc, cmd2, null, out, history, output, explain, client, quiet, delimiter);
            argDc = new Document();
            for (Object e : args) {
                argDc.put("" + ++count, e);
            }
            return MonsterCLI.runCommand(null, null, command3, argDc, cmd2, null, out, history, output, explain, client, quiet, delimiter);
        }
        if (!cmds[0].equalsIgnoreCase("aggregate") && !cmds[0].equalsIgnoreCase("stream")) return MonsterCLI.runCommand(null, null, cmds[0], null, cmd2, null, out, history, output, explain, client, quiet, delimiter);
        if (client.currentDatabase() == null) {
            System.err.println("Use a database first, ie use dbname");
            return true;
        }
        if (cmds.length <= 1) return true;
        client.useCollection(cmds[1]);
        if (cmds.length <= 2) return true;
        List<Document> pipeline = MonsterCLI.decodeStreamCommand(cmds[2]);
        MonsterCLI.runCommand(client.currentDatabase(), cmds[1], "aggregate", new Document("1", pipeline), cmd2, null, out, history, output, explain, client, quiet, delimiter);
        return true;
    }

    private static String extractNextDocument(String argString) {
        boolean inquote = false;
        boolean indquote = false;
        int curlycount = 0;
        int listcount = 0;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < argString.length(); ++i) {
            char c = argString.charAt(i);
            if (c == '\"') {
                boolean bl = indquote = !indquote;
            }
            if (c == '\'') {
                boolean bl = inquote = !inquote;
            }
            if (!indquote && !inquote) {
                if (c == '{') {
                    ++curlycount;
                }
                if (c == '}') {
                    --curlycount;
                }
                if (c == '[') {
                    ++listcount;
                }
                if (c == ']') {
                    --listcount;
                }
            }
            out.append(c);
            if (listcount == 0 && curlycount == 0) break;
        }
        return out.toString();
    }

    public static List<Document> decodeStreamCommand(String cmd) {
        String[] aggString = cmd.split("\\|");
        ArrayList<Document> pipeline = new ArrayList<Document>();
        for (String argString : aggString) {
            if ((argString = argString.replaceAll("&pipe;", "|")).indexOf("(") == -1) continue;
            String command2 = argString.substring(0, argString.indexOf("("));
            if ((argString = argString.substring(argString.indexOf("(") + 1)).indexOf(")") != -1) {
                argString = argString.substring(0, argString.lastIndexOf(")"));
            }
            Object args = null;
            if (argString.length() != 0 && argString.trim().startsWith("{")) {
                argString = argString.trim();
                String argStringFirst = MonsterCLI.extractNextDocument(argString);
                Document argso = Document.parse(argStringFirst);
                argString = argString.replace(argStringFirst, "").trim();
                Document options = null;
                if (argString.length() > 0) {
                    if (argString.startsWith(",")) {
                        argString = argString.substring(1).trim();
                    }
                    options = Document.parse(argString);
                }
                Document stage = new Document("$" + command2.trim(), argso);
                if (options != null) {
                    stage.append("options", options);
                }
                pipeline.add(stage);
                continue;
            }
            pipeline.add(new Document("$" + command2.trim(), argString.trim()));
        }
        return pipeline;
    }

    private static boolean runCommand(String db, String coll, String command2, Document argDc, String origString, String nextParts, PrintWriter out, Queue<String> history, OutputType output, boolean explain, MonsterClient client, boolean quiet, String delimiter) {
        try {
            interrupted = false;
            OutputType output2 = client.getOutputType();
            if (origString.trim().length() > 0 && history != null && !history.contains(origString)) {
                history.add(origString);
            }
            Stream<Document> ret = null;
            if (argDc != null && argDc.containsKey("1")) {
                if (nextParts != null) {
                    argDc.append("nextParts", nextParts);
                }
                ret = client.pushDocInnerStream(db, coll, command2, argDc);
            } else {
                ret = client.pushDocStream(db, coll, command2, nextParts, argDc);
            }
            boolean hasAny = false;
            if (ret != null) {
                if (output2 == OutputType.XML) {
                    out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?><" + coll + "s>");
                }
                AtomicBoolean first = new AtomicBoolean(true);
                ret.forEach(d -> {
                    if (interrupted) {
                        throw new StopIterationException("User requested cancel");
                    }
                    if (!first.getAndSet(false)) {
                        out.println(delimiter);
                    }
                    if (output2 == OutputType.Pretty) {
                        out.println(d.toPrettyJson());
                    } else if (output2 == OutputType.Json) {
                        out.println(d.toJson());
                    } else if (output2 == OutputType.XML) {
                        out.println(d.toXML(coll));
                    } else if (output2 == OutputType.CSV) {
                        out.println(d.toCSV());
                    }
                });
                if (output2 == OutputType.XML) {
                    out.println("</" + coll + "s>");
                }
            } else {
                System.err.println("Incorrect command syntax, session invalid, or database not used");
                return false;
            }
            if (!hasAny && !quiet) {
                System.out.println("No results");
            }
        }
        catch (StopIterationException eof) {
            interrupted = false;
        }
        catch (TTransportException t) {
            out.println("Session is disconnected.");
            return false;
        }
        catch (Exception t) {
            out.println("Session is disconnected.");
            return false;
        }
        return true;
    }
}

