/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.wordlist.RuleSetMap;
import com.entitystream.monster.db.BasicDBList;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.DBServer;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.IBasicDB;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.Mocument;
import com.entitystream.monster.db.NoDatabaseException;
import com.entitystream.monster.db.OutputType;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.StopIterationException;
import com.entitystream.monster.db.User;
import com.entitystream.monster.thrift.Connection;
import com.entitystream.monster.thrift.InvalidOperation;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class MonsterClient
implements ICollection,
IBasicDB,
Serializable {
    private transient ConcurrentHashMap<Long, Connection.Client> clients = new ConcurrentHashMap();
    private transient ConcurrentHashMap<Long, TTransport> transports = new ConcurrentHashMap();
    private transient ConcurrentHashMap<Long, Long> connectionIDs = new ConcurrentHashMap();
    private transient ConcurrentHashMap<Long, Boolean> connected = new ConcurrentHashMap();
    private transient ConcurrentHashMap<Long, Long> touchTime = new ConcurrentHashMap();
    protected String database;
    protected String collection;
    protected String password;
    protected String username;
    protected String connection;
    protected int port;
    private boolean remoteView = false;
    public boolean quiet = false;
    private ReentrantLock lock = new ReentrantLock();
    protected OutputType output = OutputType.Json;
    private int node = DBServer.getNodeNum();

    public MonsterClient(String connection, int port, String username, String password) throws NoDatabaseException {
        this.clients = new ConcurrentHashMap();
        this.transports = new ConcurrentHashMap();
        this.connectionIDs = new ConcurrentHashMap();
        this.connected = new ConcurrentHashMap();
        this.touchTime = new ConcurrentHashMap();
        this.connect(connection, port, username, password);
    }

    public MonsterClient(String connection, int port, long connectionid) throws NoDatabaseException {
        this.clients = new ConcurrentHashMap();
        this.transports = new ConcurrentHashMap();
        this.connectionIDs = new ConcurrentHashMap();
        this.connected = new ConcurrentHashMap();
        this.touchTime = new ConcurrentHashMap();
        this.connect(connection, port, connectionid);
    }

    public MonsterClient() {
        this.clients = new ConcurrentHashMap();
        this.transports = new ConcurrentHashMap();
        this.connectionIDs = new ConcurrentHashMap();
        this.connected = new ConcurrentHashMap();
        this.touchTime = new ConcurrentHashMap();
    }

    public MonsterClient(String r) {
        this.clients = new ConcurrentHashMap();
        this.transports = new ConcurrentHashMap();
        this.connectionIDs = new ConcurrentHashMap();
        this.connected = new ConcurrentHashMap();
        this.touchTime = new ConcurrentHashMap();
        int p = 27018;
        String un = null;
        String pw = null;
        if (r.split("@").length > 1) {
            un = r.split("@")[0];
            r = r.split("@")[1];
            if (un.indexOf(":") > -1) {
                pw = un.split(":")[1];
                un = un.split(":")[0];
            }
        }
        if (r.split(":").length > 1) {
            p = Integer.parseInt(r.split(":")[1]);
            r = r.split(":")[0];
        }
        this.connect(r, p, un, pw);
    }

    public MonsterClient clone() {
        MonsterClient client = new MonsterClient(this.connection, this.port, this.username, this.password);
        client.database = this.database;
        client.collection = this.collection;
        client.remoteView = this.remoteView;
        return client;
    }

    public long getInternalConnectionID() {
        return this.connectionIDs.get(Thread.currentThread().getId());
    }

    public void interrupt(long connectionID) throws TException {
        this.getClient().closeConnection(connectionID);
    }

    public void connect(String connection, int port, long connectionid) {
        try {
            this.connected.put(Thread.currentThread().getId(), false);
            this.connection = connection;
            this.port = port;
            if (this.transports.containsKey(Thread.currentThread().getId())) {
                this.transports.remove(Thread.currentThread().getId());
            }
            this.reconnect(connectionid);
        }
        catch (TException x) {
            throw new NoDatabaseException(x.toString());
        }
    }

    public void connect(String connection, int port, String username, String password) {
        try {
            this.connected.put(Thread.currentThread().getId(), false);
            this.username = username;
            this.password = password;
            this.connection = connection;
            this.port = port;
            if (this.transports.containsKey(Thread.currentThread().getId())) {
                this.transports.remove(Thread.currentThread().getId());
            }
            this.reconnect();
        }
        catch (TException x) {
            throw new NoDatabaseException(x.toString());
        }
    }

    long reconnect(long handlerID) throws InvalidOperation, TException {
        this.lock.lock();
        if (this.transports.containsKey(Thread.currentThread().getId())) {
            try {
                this.transports.remove(Thread.currentThread().getId()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TSocket transport = new TSocket(this.connection, this.port);
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        this.transports.put(Thread.currentThread().getId(), (TTransport)transport);
        Connection.Client client = new Connection.Client((TProtocol)protocol);
        this.clients.put(Thread.currentThread().getId(), client);
        this.connectionIDs.put(Thread.currentThread().getId(), handlerID);
        this.lock.unlock();
        if (!this.quiet) {
            if (this.username != null) {
                System.out.println("Connected to " + this.connection + ":" + this.port + " as " + this.username);
            } else {
                System.out.println("Connected to " + this.connection + ":" + this.port);
            }
        }
        this.connected.put(Thread.currentThread().getId(), true);
        this.touchTime.put(Thread.currentThread().getId(), System.currentTimeMillis());
        return handlerID;
    }

    boolean reconnect() throws InvalidOperation, TException {
        this.lock.lock();
        if (this.transports.containsKey(Thread.currentThread().getId())) {
            try {
                this.transports.remove(Thread.currentThread().getId()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TSocket transport = new TSocket(this.connection, this.port);
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        this.transports.put(Thread.currentThread().getId(), (TTransport)transport);
        Connection.Client client = new Connection.Client((TProtocol)protocol);
        this.clients.put(Thread.currentThread().getId(), client);
        long connectionID = client.connect(this.username, this.password);
        this.connectionIDs.put(Thread.currentThread().getId(), connectionID);
        this.lock.unlock();
        if (connectionID != -1L) {
            if (!this.quiet) {
                if (this.username != null) {
                    System.out.println("Connected to " + this.connection + ":" + this.port + " as " + this.username);
                } else {
                    System.out.println("Connected to " + this.connection + ":" + this.port);
                }
            }
            this.connected.put(Thread.currentThread().getId(), true);
            this.touchTime.put(Thread.currentThread().getId(), System.currentTimeMillis());
            return true;
        }
        if (this.username != null) {
            System.err.println("Failed to authenticate, try again");
        } else {
            System.err.println("Username null but remote system expects one");
        }
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Connection.Client getClient() {
        Connection.Client client = this.clients.get(Thread.currentThread().getId());
        if (client == null) {
            try {
                this.reconnect();
                client = this.clients.get(Thread.currentThread().getId());
            }
            catch (TException e) {
                e.printStackTrace();
            }
        }
        if (client != null) {
            this.touchTime.put(Thread.currentThread().getId(), System.currentTimeMillis());
        }
        return client;
    }

    @Override
    public void disconnect() throws Exception {
        try {
            this.lock.lock();
            if (this.clients.containsKey(Thread.currentThread().getId())) {
                this.clients.remove(Thread.currentThread().getId()).closeConnection(this.connectionIDs.get(Thread.currentThread().getId()));
            }
            this.lock.unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.transports.containsKey(Thread.currentThread().getId())) {
            this.transports.remove(Thread.currentThread().getId()).close();
        }
        this.connected.remove(Thread.currentThread().getId());
    }

    private long runCommand(String database, String collection, String command2) throws Exception {
        long retur;
        block9: {
            boolean ok = false;
            if (this.connectionIDs.containsKey(Thread.currentThread().getId())) {
                ok = this.connectionIDs.get(Thread.currentThread().getId()) != -1L;
            }
            retur = -1L;
            try {
                if (!this.isConnected()) {
                    ok = this.reconnect();
                }
                if (ok) {
                    block8: {
                        this.lock.lock();
                        try {
                            retur = this.getClient().command(this.connectionIDs.get(Thread.currentThread().getId()), database, collection, command2, this.remoteView);
                        }
                        catch (TTransportException ttt) {
                            ok = this.reconnect();
                            if (!ok) break block8;
                            retur = this.getClient().command(this.connectionIDs.get(Thread.currentThread().getId()), database, collection, command2, this.remoteView);
                        }
                    }
                    this.lock.unlock();
                    break block9;
                }
                retur = -1L;
            }
            catch (Exception e) {
                System.err.println("I'm trying to send an command to " + this.connectionIDs.get(Thread.currentThread().getId()) + ", but a error occurs: " + e.toString());
                this.disconnect();
                if (this.lock.isLocked()) {
                    this.lock.unlock();
                }
                retur = -1L;
            }
        }
        return retur;
    }

    public static Document toDocument(ByteBuffer bb) {
        if (bb.capacity() != 0) {
            String string = new String(bb.array());
            Document out = null;
            if (string != null) {
                out = Document.parse(string);
            }
            return out;
        }
        return null;
    }

    @Override
    public IBasicDB useDatabase(String db) {
        for (Document d : this.listDatabaseNames()) {
            if (!d.containsKey("value") || !d.getString("value").equalsIgnoreCase(db)) continue;
            this.database = db;
            return this;
        }
        this.createDatabase(db);
        return this;
    }

    @Override
    public IBasicDB useCollection(String coll) {
        this.collection = coll;
        return this;
    }

    @Override
    public DBCursor listDatabaseNames() {
        BasicDBList list = null;
        try {
            ByteBuffer bb;
            long cursor = this.runCommand(null, null, new Document("MethodName", "listDatabaseNames").toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0) {
                Document d = MonsterClient.toDocument(bb);
                list = new BasicDBList(d.getList("list"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DBCursor((Object)list);
    }

    @Override
    public DBCursor listCollectionNames() {
        BasicDBList list = null;
        try {
            Document d;
            ByteBuffer bb;
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "listCollectionNames").toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0 && (d = MonsterClient.toDocument(bb)) != null) {
                list = new BasicDBList(d.getList("list"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DBCursor((Object)list);
    }

    @Override
    public String createDatabase(String db) {
        try {
            long cursor = this.runCommand(null, null, new Document("MethodName", "createDatabase").append("1", db).toJson());
            if (cursor != -1L) {
                ByteBuffer bb = this.cursorNext(cursor, -1);
                if (bb.capacity() != 0) {
                    String dbname;
                    this.database = dbname = new String(bb.array());
                    return dbname;
                }
                this.database = db;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createCollection(String coll) {
        try {
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "getCollection").append("1", coll).toJson());
            if (cursor != -1L) {
                ByteBuffer bb = this.cursorNext(cursor, -1);
                if (bb.capacity() != 0) {
                    String collname;
                    this.collection = collname = new String(bb.array());
                    return this.collection;
                }
                this.collection = coll;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Document describeCollection(String coll) {
        try {
            ByteBuffer bb;
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "describeCollection").append("1", coll).toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0) {
                String doc = new String(bb.array());
                return Document.parse(doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createCollection(String coll, String hashKey) {
        try {
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "getCollection").append("1", coll).append("2", hashKey).toJson());
            if (cursor != -1L) {
                ByteBuffer bb = this.cursorNext(cursor, -1);
                if (bb.capacity() != 0) {
                    String collname;
                    this.collection = collname = new String(bb.array());
                    return this.collection;
                }
                this.collection = coll;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createCollection(String coll, Document ranges) {
        try {
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "createCollection").append("1", coll).append("2", ranges).toJson());
            if (cursor != -1L) {
                ByteBuffer bb = this.cursorNext(cursor, -1);
                if (bb.capacity() != 0) {
                    String collname;
                    this.collection = collname = new String(bb.array());
                    return this.collection;
                }
                this.collection = coll;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createFuzzyCollection(String name, String definitionFile, String ruleSetPath) {
        try {
            ByteBuffer bb;
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "createFuzzyCollection").append("1", name).append("2", definitionFile).append("3", ruleSetPath).toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0) {
                String collname;
                this.collection = collname = new String(bb.array());
                return this.collection;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createFuzzyCollection(String name, String definitionFile, String ruleSetPath, String hashKey) {
        try {
            ByteBuffer bb;
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "createFuzzyCollection").append("1", name).append("2", definitionFile).append("3", ruleSetPath).append("4", hashKey).toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0) {
                String collname;
                this.collection = collname = new String(bb.array());
                return this.collection;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createFuzzyCollection(String name, String definitionFile, String ruleSetPath, Document ranges) {
        try {
            ByteBuffer bb;
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "createFuzzyCollection").append("1", name).append("2", definitionFile).append("3", ruleSetPath).append("4", ranges).toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0) {
                String collname;
                this.collection = collname = new String(bb.array());
                return this.collection;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createCollection(Document collDoc) {
        try {
            ByteBuffer bb;
            long cursor = this.runCommand(this.database, null, new Document("MethodName", "createCollection").append("1", collDoc).toJson());
            if (cursor != -1L && (bb = this.cursorNext(cursor, -1)).capacity() != 0) {
                String collname;
                this.collection = collname = new String(bb.array());
                return this.collection;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ByteBuffer cursorNext(long cursor, int i) throws InvalidOperation, TException {
        try {
            this.lock.lock();
            long id = -1L;
            if (this.connectionIDs.containsKey(Thread.currentThread().getId())) {
                id = this.connectionIDs.get(Thread.currentThread().getId());
            }
            ByteBuffer bb = null;
            if (id != -1L) {
                bb = this.getClient().cursorNext(id, cursor, -1);
            }
            this.lock.unlock();
            if (bb == null) {
                bb = ByteBuffer.allocate(0);
            }
            return bb;
        }
        catch (StopIterationException ignore) {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                this.lock.unlock();
            }
            return ByteBuffer.allocate(0);
        }
        catch (TTransportException e) {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                this.lock.unlock();
            }
            System.out.println("Transport Exception has occurred, like the server has gone offline, or you have been disconnected");
            return ByteBuffer.allocate(0);
        }
        catch (TException e) {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                this.lock.unlock();
            }
            System.out.println("Session has been disconnected");
            return ByteBuffer.allocate(0);
        }
    }

    public Stream<Document> remoteGetStream(final long connectionID, final long cursorID) {
        final MonsterClient client = this;
        final AtomicBoolean shouldreturnnull = new AtomicBoolean(true);
        try {
            Stream<Document> ret = Stream.generate(new Supplier<Object>(){

                @Override
                public Object get() {
                    Object o = null;
                    try {
                        ByteBuffer bb = MonsterClient.this.remoteGetCursorNext(connectionID, cursorID, 100);
                        if (bb.capacity() == 0) {
                            return null;
                        }
                        String ss = new String(bb.array());
                        o = Mocument.parseListOrDocument(client, ss);
                        shouldreturnnull.set(false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return o;
                }
            }).takeWhile(o -> o != null).map(o -> {
                List<Mocument> l = null;
                if (o instanceof BasicDBList) {
                    l = ((BasicDBList)o).toList();
                }
                if (o instanceof Document) {
                    l = Collections.singletonList(new Mocument((Document)o, client));
                }
                return l.stream();
            }).filter(o -> o != null).flatMap(in -> in);
            if (shouldreturnnull.get()) {
                return null;
            }
            return ret;
        }
        catch (Exception eof) {
            try {
                System.out.println("EOF");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Stream.empty();
    }

    private ByteBuffer remoteGetCursorNext(long id, long cursor, int i) throws InvalidOperation, TException {
        try {
            this.lock.lock();
            ByteBuffer bb = null;
            if (id != -1L) {
                bb = this.getClient().cursorNext(id, cursor, -1);
            }
            this.lock.unlock();
            if (bb == null) {
                bb = ByteBuffer.allocate(0);
            }
            return bb;
        }
        catch (StopIterationException ignore) {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                this.lock.unlock();
            }
            return ByteBuffer.allocate(0);
        }
        catch (TTransportException e) {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                this.lock.unlock();
            }
            System.out.println("Transport Exception has occurred, like the server has gone offline, or you have been disconnected");
            return ByteBuffer.allocate(0);
        }
        catch (TException e) {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                this.lock.unlock();
            }
            System.out.println("Exception has occurred, like the server has gone offline, or you have been disconnected");
            return ByteBuffer.allocate(0);
        }
    }

    public DBCursor pushDocInner(String database, String collection, String command2, Document send) throws Exception {
        send.append("MethodName", command2);
        BasicDBList list = null;
        long cursor = this.runCommand(database, collection, send.toJson());
        if (cursor != -1L) {
            if (this.output == OutputType.BROWSER) {
                this.browser(cursor, this.connectionIDs.get(Thread.currentThread().getId()));
            } else {
                try {
                    Document dd = new Document();
                    list = new BasicDBList();
                    while (dd != null) {
                        ByteBuffer bb = this.cursorNext(cursor, 100);
                        if (bb.capacity() != 0) {
                            String ss = new String(bb.array());
                            Object o = Mocument.parseListOrDocument(this, ss);
                            if (o instanceof BasicDBList) {
                                list.addAll((BasicDBList)o);
                            }
                            if (!(o instanceof Document)) continue;
                            list.add(new Mocument(dd, this));
                            continue;
                        }
                        dd = null;
                    }
                }
                catch (InvalidOperation ioe) {
                    ioe.printStackTrace();
                }
            }
        } else {
            return new DBCursor();
        }
        return new DBCursor((Object)list);
    }

    public Stream<Document> pushDocInnerStream(String database, String collection, String command2, Document send) {
        block6: {
            send.append("MethodName", command2);
            try {
                final long cursor = this.runCommand(database, collection, send.toJson());
                if (cursor != -1L) {
                    if (this.output == OutputType.BROWSER) {
                        this.browser(cursor, this.connectionIDs.get(Thread.currentThread().getId()));
                        break block6;
                    }
                    final MonsterClient client = this;
                    try {
                        return Stream.generate(new Supplier<Object>(){

                            @Override
                            public Object get() {
                                Object o = null;
                                try {
                                    ByteBuffer bb = MonsterClient.this.cursorNext(cursor, 100);
                                    if (bb.capacity() == 0) {
                                        return null;
                                    }
                                    String ss = new String(bb.array());
                                    o = Mocument.parseListOrDocument(client, ss);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                return o;
                            }
                        }).takeWhile(o -> o != null).map(o -> {
                            List<Mocument> l = null;
                            if (o instanceof BasicDBList) {
                                l = ((BasicDBList)o).toList();
                            }
                            if (o instanceof Document) {
                                l = Collections.singletonList(new Mocument((Document)o, client));
                            }
                            return l.stream();
                        }).filter(o -> o != null).flatMap(in -> in);
                    }
                    catch (Exception eof) {
                        System.out.println("EOF");
                        break block6;
                    }
                }
                System.out.println("No cursor from " + send.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Stream.empty();
    }

    public DBCursor pushDoc(String database, String collection, String command2, Object ... docs) {
        return this.pushDoc(database, collection, command2, null, docs);
    }

    public DBCursor pushDoc(String database, String collection, String command2, String nextParts, Object ... docs) {
        Document send = new Document("MethodName", command2);
        if (nextParts != null) {
            send.append("nextParts", nextParts);
        }
        try {
            int pos = 0;
            if (docs != null) {
                for (Object doc : docs) {
                    if (doc == null) continue;
                    send.append("" + ++pos, doc);
                }
            }
            return this.pushDocInner(database, collection, command2, send);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return new DBCursor();
        }
    }

    public Stream<Document> pushDocStream(String database, String collection, String command2, String nextParts, Object ... docs) {
        Document send = new Document("MethodName", command2);
        if (nextParts != null) {
            send.append("nextParts", nextParts);
        }
        try {
            int pos = 0;
            if (docs != null) {
                for (Object doc : docs) {
                    if (doc == null) continue;
                    send.append("" + ++pos, doc);
                }
            }
            return this.pushDocInnerStream(database, collection, command2, send);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return Stream.empty();
        }
    }

    private void browser(long cursor, long connID) {
        block7: {
            String url = "http://" + this.username + ":" + this.password + "@" + this.connection + ":" + (this.port + 1) + "/api/" + this.database + "/" + this.collection + "?cursor=" + cursor;
            if (this.username == null) {
                url = "http://" + this.connection + ":" + (this.port + 1) + "/api/" + this.database + "/" + this.collection + "?cursor=" + cursor + "&connection=" + connID;
            }
            String os = System.getProperty("os.name").toLowerCase();
            Runtime rt = Runtime.getRuntime();
            try {
                if (os.indexOf("win") >= 0) {
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break block7;
                }
                if (os.indexOf("mac") >= 0) {
                    rt.exec("open " + url);
                    break block7;
                }
                if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                    String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                    StringBuffer cmd = new StringBuffer();
                    for (int i = 0; i < browsers.length; ++i) {
                        cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                    }
                    rt.exec(new String[]{"sh", "-c", cmd.toString()});
                    break block7;
                }
                return;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @Override
    public void createIndex(Document fields, Document options) {
        this.pushDoc(this.database, this.collection, "createIndex", null, fields, options);
    }

    @Override
    public void createIndex(Document fields) {
        try {
            this.pushDoc(this.database, this.collection, "createIndex", null, fields);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createUniqueIndex(Document fields) {
        try {
            this.pushDoc(this.database, this.collection, "createUniqueIndex", null, fields);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DBCursor find(Document query) {
        try {
            return this.pushDoc(this.database, this.collection, "find", null, query);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public DBCursor find() {
        try {
            return this.pushDoc(this.database, this.collection, "find", null, new Document());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public DBCursor findFuzzy(Document filter) {
        try {
            return this.pushDoc(this.database, this.collection, "findFuzzy", null, filter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public DBCursor findFuzzy(String textQuery) {
        try {
            return this.pushDoc(this.database, this.collection, "findFuzzy", null, textQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public Document save(Document doc) {
        try {
            return this.pushDoc(this.database, this.collection, "save", null, doc).first();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document insertOne(Document newDocument) {
        try {
            return this.pushDoc(this.database, this.collection, "insertOne", null, newDocument).first();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long count(Document query) {
        try {
            Document d = this.pushDoc(this.database, this.collection, "count", null, query).first();
            if (d != null) {
                return d.getInteger("Number").intValue();
            }
            return 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement, Document options) {
        return this.pushDoc(this.database, this.collection, "findOneAndReplace", null, filter, replacement, options).first();
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement) {
        try {
            return this.pushDoc(this.database, this.collection, "findOneAndReplace", null, filter, replacement).first();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments) {
        return this.pushDoc(this.database, this.collection, "findOneAndUpdate", null, filter, amendments).first();
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments, Document options) {
        return this.pushDoc(this.database, this.collection, "findOneAndUpdate", null, filter, amendments, options).first();
    }

    @Override
    public Document updateOne(Document filter, Document amendments) {
        return this.pushDoc(this.database, this.collection, "updateOne", null, filter, amendments).first();
    }

    @Override
    public Document updateOne(Document filter, Document amendments, Document options) {
        return this.pushDoc(this.database, this.collection, "updateOne", null, filter, amendments, options).first();
    }

    @Override
    public int updateMany(Document filter, Document amendments, Document options) {
        return this.pushDoc(this.database, this.collection, "updateMany", null, filter, amendments, options).count();
    }

    @Override
    public int updateMany(Document filter, Document amendments) {
        return this.pushDoc(this.database, this.collection, "updateMany", null, filter, amendments, new Document()).count();
    }

    @Override
    public int insertMany(List<Document> listRecs) {
        return this.pushDoc(this.database, this.collection, "insertMany", null, listRecs).first().getInteger("Number", 0);
    }

    @Override
    public Document findOneAndDelete(Document filter) {
        try {
            return this.pushDoc(this.database, this.collection, "findOneAndDelete", null, filter).first();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document deleteOne(Document filter) {
        try {
            return this.pushDoc(this.database, this.collection, "deleteOne", null, filter).first();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int deleteMany(Document filter) {
        try {
            return this.pushDoc(this.database, this.collection, "deleteMany", null, filter).first().getInteger("Number");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public Stream<Document> aggregate(List<Document> in, List<Document> pipeline) {
        return this.pushDocStream(this.database, this.collection, "aggregate", null, in, pipeline, new Document());
    }

    @Override
    public Document aggregateMetadata(List<Document> in, List<Document> pipeline) {
        return this.pushDocStream(this.database, this.collection, "aggregateMetadata", null, in, pipeline, new Document()).findFirst().get();
    }

    @Override
    public Document aggregateMetadata(List<Document> pipeline) {
        return this.pushDocStream(this.database, this.collection, "aggregateMetadata", null, pipeline, new Document()).findFirst().get();
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline, Document options) {
        return this.pushDocStream(this.database, this.collection, "aggregate", null, pipeline, options);
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline) {
        return this.pushDocStream(this.database, this.collection, "aggregate", null, pipeline);
    }

    @Override
    public DBCursor listIndexes() {
        return this.pushDoc(this.database, this.collection, "listIndexes", new Object[0]);
    }

    @Override
    public void dropCollection() {
        this.pushDoc(this.database, null, "dropCollection", null, this.collection);
    }

    @Override
    public void dropDatabase() {
        this.pushDoc(this.database, null, "drop", new Object[0]);
    }

    @Override
    public String currentDatabase() {
        return this.database;
    }

    @Override
    public void rebuildIndex(String name) {
        this.pushDoc(this.database, null, "rebuildIndex", null, name);
    }

    @Override
    public void dropIndex(String name) {
        this.pushDoc(this.database, null, "dropIndex", null, name);
    }

    @Override
    public int saveMany(List<Document> records) {
        try {
            this.pushDoc(this.database, this.collection, "saveMany", null, records);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isConnected() {
        return this.transports.containsKey(Thread.currentThread().getId()) && this.transports.get(Thread.currentThread().getId()).peek() && this.connected.containsKey(Thread.currentThread().getId()) && this.connected.get(Thread.currentThread().getId()) != false && System.currentTimeMillis() - this.touchTime.get(Thread.currentThread().getId()) < 60000L;
    }

    @Override
    public void setExplaining(boolean explain) {
        try {
            this.pushDoc(this.database, this.collection, "setExplaining", null, explain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTrigger(String name) {
        try {
            this.pushDoc(this.database, this.collection, "addTrigger", null, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DBCursor find(Document query, Document explain) {
        try {
            return this.pushDoc(this.database, this.collection, "find", null, query, explain);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public DBCursor executeCommand(String command2, User user, Session session) {
        try {
            if (!command2.contains("MethodName")) {
                return this.pushDoc(this.database, this.collection, command2, new Object[0]);
            }
            Document d = Document.parse(command2);
            if (d != null) {
                return this.pushDocInner(this.database, this.collection, d.getString("MethodName"), d);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void drop() {
        try {
            this.pushDoc(this.database, this.collection, "drop", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            this.pushDoc(null, null, "shutdown", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public <TResult> Iterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        try {
            return this.pushDoc(this.database, this.collection, "distinct", null, fieldName, resultClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document getDocument(Object pointer) {
        return this.pushDoc(this.database, this.collection, "getDocument", null, pointer).first();
    }

    @Override
    public Document getIndexPrefixSubMap(String indexName, String key, boolean b) {
        return this.pushDoc(this.database, this.collection, "getIndexPrefixSubMap", null, indexName, key, b).first();
    }

    @Override
    public Document keyCount(String indexName) {
        return this.pushDoc(this.database, this.collection, "keyCount", null, indexName).first();
    }

    @Override
    public Document conceptCount(String indexName) {
        return this.pushDoc(this.database, this.collection, "conceptCount", null, indexName).first();
    }

    @Override
    public Document getStandardised(String indexName, String id) {
        return this.pushDoc(this.database, this.collection, "getStandardised", null, indexName, id).first();
    }

    public boolean isRemoteView() {
        return this.remoteView;
    }

    public MonsterClient setRemoteView(boolean remoteView) {
        this.remoteView = remoteView;
        return this;
    }

    @Override
    public int getNodeNum() {
        return this.pushDoc(null, null, "getNodeNum", new Object[0]).first().getInteger("Number");
    }

    @Override
    public void saveTable(Document def) {
        this.pushDoc(this.database, this.collection, "saveTable", null, def);
    }

    @Override
    public void setAutoMatch(boolean def) {
        this.pushDoc(this.database, this.collection, "setAutoMatch", null, def);
    }

    @Override
    public Document getTable(String def) {
        return this.pushDoc(this.database, this.collection, "getTable", null, def).first();
    }

    @Override
    public void deleteTable(String name) {
        this.pushDoc(this.database, this.collection, "deleteTable", null, name);
    }

    @Override
    public void saveConceptGroup(Document def) {
        this.pushDoc(this.database, this.collection, "saveConceptGroup", null, def);
    }

    @Override
    public void deleteConceptGroup(String name) {
        this.pushDoc(this.database, this.collection, "deleteConceptGroup", null, name);
    }

    @Override
    public void saveConcept(Document def) {
        this.pushDoc(this.database, this.collection, "saveConcept", null, def);
    }

    @Override
    public void deleteConcept(String purposeName, String purposeColumn) {
        this.pushDoc(this.database, this.collection, "deleteConcept", null, purposeName, purposeColumn);
    }

    @Override
    public void saveConceptMapping(Document def) {
        this.pushDoc(this.database, this.collection, "saveConceptMapping", null, def);
    }

    @Override
    public void deleteConceptMapping(Document def) {
        this.pushDoc(this.database, this.collection, "deleteConceptMapping", null, def);
    }

    @Override
    public void saveQualityRule(Document def) {
        this.pushDoc(this.database, null, "saveQualityRule", null, def);
    }

    @Override
    public DBCursor findQualityRules(Document def) {
        return this.pushDoc(this.database, null, "findQualityRules", null, def);
    }

    @Override
    public void saveMatchRule(Document def) {
        this.pushDoc(this.database, this.collection, "saveMatchRule", null, def);
    }

    @Override
    public void saveMatchRules(List<Document> defs) {
        this.pushDoc(this.database, this.collection, "saveMatchRules", null, defs);
    }

    @Override
    public void deleteMatchRule(long order) {
        this.pushDoc(this.database, this.collection, "deleteMatchRule", null, order);
    }

    @Override
    public void saveFuzzyIndex(Document def) {
        this.pushDoc(this.database, this.collection, "saveFuzzyIndex", null, def);
    }

    @Override
    public void deleteFuzzyIndex(String name) {
        this.pushDoc(this.database, this.collection, "deleteFuzzyIndex", null, name);
    }

    @Override
    public void removeFuzzy() {
        this.pushDoc(this.database, this.collection, "removeFuzzy", null);
    }

    @Override
    public void setRuleSetPath(String path) {
        this.pushDoc(null, null, "setRuleSetPath", null, path);
    }

    @Override
    public void saveRuleSet(String path) {
        this.pushDoc(null, null, "saveRuleSet", null, path);
    }

    @Override
    public void setRuleSet(RuleSetMap map) {
        this.pushDoc(null, null, "setRuleSet", null, map);
    }

    @Override
    public Document getDefinition() {
        return this.pushDoc(this.database, this.collection, "getDefinition", null).first();
    }

    @Override
    public void updateDefinition(Document def) {
        if (def == null) {
            def = new Document();
        }
        this.pushDoc(this.database, this.collection, "updateDefinition", null, def);
    }

    @Override
    public void updateDelta(Document def) {
        if (def == null) {
            def = new Document();
        }
        this.pushDoc(this.database, this.collection, "updateDelta", null, def);
    }

    @Override
    public DBCursor findRelationships(Document filter) {
        if (filter == null) {
            filter = new Document();
        }
        return this.pushDoc(this.database, this.collection, "findRelationships", null, filter);
    }

    @Override
    public DBCursor findTasks(Document filter) {
        if (filter == null) {
            filter = new Document();
        }
        return this.pushDoc(this.database, this.collection, "findTasks", null, filter);
    }

    @Override
    public void resolveTask(Document document) {
        this.pushDoc(this.database, this.collection, "resolveTask", null, document);
    }

    @Override
    public Document saveRelationship(Document relationship) {
        return this.pushDoc(this.database, this.collection, "saveRelationship", null, relationship).first();
    }

    @Override
    public DBCursor aggregateTasks(ArrayList<Document> andlist) {
        return this.pushDoc(this.database, this.collection, "aggregateTasks", null, andlist);
    }

    @Override
    public Document updateTask(String id, Document doc) {
        return this.pushDoc(this.database, this.collection, "updateTask", null, id, doc).first();
    }

    @Override
    public <TResult> Iterable<TResult> distinctRelationship(String fieldName, Class<TResult> resultClass) {
        try {
            return this.pushDoc(this.database, this.collection, "distinctRelationship", null, fieldName, resultClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document updateRelationship(Document document, Document setUpdate, Document options) {
        return this.pushDoc(this.database, this.collection, "updateRelationship", null, document, setUpdate, options).first();
    }

    @Override
    public DBCursor peekQueue() {
        return this.pushDoc(this.database, this.collection, "peekQueue", null);
    }

    @Override
    public void deleteTasks(Document document) {
        this.pushDoc(this.database, this.collection, "deleteTasks", document);
    }

    @Override
    public void deleteRelationships(Document document) {
        this.pushDoc(this.database, this.collection, "deleteRelationships", document);
    }

    @Override
    public void setScriptCode(String code) {
        this.pushDoc(this.database, null, "setScriptCode", code, new Object[0]);
    }

    @Override
    public void setScriptPath(String path) {
        this.pushDoc(this.database, null, "setScriptPath", path, new Object[0]);
    }

    public OutputType getOutputType() {
        return this.output;
    }

    public void setOutputType(OutputType o) {
        this.output = o;
    }

    @Override
    public Stream<Document> findStream(Document query) {
        try {
            return this.pushDocStream(this.database, this.collection, "findStream", null, query);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<Integer, ICollection> getReplicaConnections() {
        return null;
    }

    @Override
    public Stream<Document> getNodes() {
        try {
            return this.pushDocStream(this.database, this.collection, "getNodes", null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> match(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("match", asDocument, in, options);
    }

    private Stream<Document> remoteAggregate(String command2, Object asDocument, Stream<Document> in, Document options) {
        try {
            DBCursor curs = new DBCursor(in);
            long connectionID = DBServer.getHandler().connect(this.username, this.password);
            long cursorID = DBServer.getHandler().addCursor(connectionID, curs, asDocument.toString());
            Stream<Document> output = this.pushDocStream(this.database, this.collection, command2, null, asDocument, this.node, connectionID, cursorID, options);
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> analyse(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("analyse", asDocument, in, options);
    }

    @Override
    public Stream<Document> limit(long long1, Stream<Document> in, Document options) {
        return this.remoteAggregate("limit", long1, in, options);
    }

    @Override
    public Stream<Document> lookup(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("lookup", asDocument, in, options);
    }

    @Override
    public Stream<Document> join(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("join", asDocument, in, options);
    }

    @Override
    public Stream<Document> minus(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("minus", asDocument, in, options);
    }

    @Override
    public Stream<Document> skip(long long1, Stream<Document> in, Document options) {
        return this.remoteAggregate("skip", long1, in, options);
    }

    @Override
    public Stream<Document> group(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("group", asDocument, in, options);
    }

    @Override
    public Stream<Document> out(String string, Stream<Document> in, Document options) {
        return this.remoteAggregate("out", string, in, options);
    }

    @Override
    public Stream<Document> sort(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("sort", asDocument, in, options);
    }

    @Override
    public Stream<Document> bucket(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("bucket", asDocument, in, options);
    }

    @Override
    public Stream<Document> fuzzySearch(String string, Stream<Document> in, Document options) {
        return this.remoteAggregate("fuzzySearch", string, in, options);
    }

    @Override
    public Stream<Document> fuzzyMatch(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("fuzzyMatch", asDocument, in, options);
    }

    @Override
    public Stream<Document> unwind(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("unwind", asDocument, in, options);
    }

    @Override
    public Stream<Document> spinOut(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("spinOut", asDocument, in, options);
    }

    @Override
    public Stream<Document> getRelated(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("getRelated", asDocument, in, options);
    }

    @Override
    public Stream<Document> rematch(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("rematch", asDocument, in, options);
    }

    @Override
    public Stream<Document> classifierBuild(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("classifierBuild", asDocument, in, options);
    }

    @Override
    public Stream<Document> classifierPredict(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("classifierPredict", asDocument, in, options);
    }

    @Override
    public Stream<Document> arrf(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("arrf", asDocument, in, options);
    }

    @Override
    public Stream<Document> classifierTree(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("classifierTree", asDocument, in, options);
    }

    @Override
    public Stream<Document> coerce(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("coerce", asDocument, in, options);
    }

    @Override
    public Stream<Document> compare(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("compare", asDocument, in, options);
    }

    @Override
    public Stream<Document> count(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("count", asDocument, in, options);
    }

    @Override
    public Stream<Document> first(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("first", asDocument, in, options);
    }

    @Override
    public Stream<Document> last(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("last", asDocument, in, options);
    }

    @Override
    public Stream<Document> between(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("between", asDocument, in, options);
    }

    @Override
    public Stream<Document> cluster(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("cluster", asDocument, in, options);
    }

    @Override
    public Stream<Document> project(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("project", asDocument, in, options);
    }

    @Override
    public Stream<Document> evaluate(Document asDocument, Stream<Document> in, Document options) {
        return this.remoteAggregate("evaluate", asDocument, in, options);
    }

    @Override
    public Map<Document, List<Document>> split(List<Document> list, Stream<Document> in, Document options) {
        try {
            throw new Exception("split function cannot be called remotely");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Database getDatabase() {
        try {
            throw new Exception("getDatabase function cannot be called directly");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getTrigger() {
        return null;
    }

    @Override
    public Document fuzzyMatch(Document matchNode, List<IIndex> matchIndexes) {
        return this.pushDoc(this.database, this.collection, "fuzzyMatch", matchNode, matchIndexes).first();
    }

    public void connect(String value) {
        try {
            URI url = new URI(value);
            if (url.getScheme().equalsIgnoreCase("monsterdb")) {
                String host = url.getHost();
                int port = url.getPort();
                if (port == -1) {
                    port = 27018;
                }
                String username = url.getUserInfo();
                String password = null;
                if (username != null && username.indexOf(":") > -1) {
                    password = username.split(":")[1];
                    username = username.split(":")[0];
                }
                this.connect(host, port, username, password);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public String getAddress() {
        return this.connection;
    }

    @Override
    public DBCursor traverseTop(Document from, String relType) {
        return this.pushDoc(this.database, this.collection, "traverseTop", null, from, relType);
    }

    @Override
    public Stream<Document> writeRel(Document options, Stream<Document> in, Document goptions) {
        return this.remoteAggregate("writeRel", options, in, goptions);
    }

    @Override
    public Stream<Document> script(Document scriptStatements, Stream<Document> in, Document stageoptions) {
        return null;
    }

    @Override
    public DBCursor getMatchTypes() {
        try {
            return this.pushDoc(this.database, this.collection, "getMatchTypes", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public void saveFuzzyIndexes(List<Document> def) {
        this.pushDoc(this.database, this.collection, "saveFuzzyIndexes", def);
    }

    @Override
    public DBCursor getFlows() {
        try {
            return this.pushDoc(this.database, this.collection, "getFlows", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public DBCursor getBooks() {
        try {
            return this.pushDoc(this.database, this.collection, "getBooks", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public DBCursor getFlow(String name) {
        try {
            return this.pushDoc(this.database, this.collection, "getFlow", null, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DBCursor();
        }
    }

    @Override
    public Stream<Document> validate(String type, Stream<Document> in, Document goptions) {
        return this.remoteAggregate("validate", type, in, goptions);
    }

    @Override
    public Stream<Document> task(Document options, Stream<Document> in, Document globalOptions) {
        return this.remoteAggregate("task", options, in, globalOptions);
    }

    @Override
    public Document saveTask(Document task) {
        return this.pushDoc(this.database, this.collection, "saveTask", null, task).first();
    }

    @Override
    public Stream<Document> getDeltas() {
        return this.pushDoc(this.database, this.collection, "getDeltas", null).stream();
    }
}

