/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.extract.TizaReader;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.Table;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.monster.db.BasicDBList;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.monster.db.NoDatabaseException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import picocli.CommandLine;

public class MonsterLoadCLI
extends MonsterClient
implements Runnable {
    @CommandLine.Option(names={"-h", "--host"}, required=true, description={"Remote host IP or DNS Name"})
    private String host;
    @CommandLine.Option(names={"-p", "--port"}, required=false, description={"Remote host port (default 27018)"})
    private int port;
    @CommandLine.Option(names={"-u", "--user"}, required=false, description={"The username to connect with"})
    private String username;
    @CommandLine.Option(names={"-pw", "--password"}, required=false, description={"The usernames password"})
    private String password;
    @CommandLine.Option(names={"-c", "--collection"}, required=true, description={"Collection to load"})
    private String collection;
    @CommandLine.Option(names={"-d", "--db"}, required=true, description={"DB to load"})
    private String db;
    @CommandLine.Option(names={"-f", "--file"}, required=true, description={"File to load"})
    private String filename;
    @CommandLine.Option(names={"-r", "--recordType"}, required=false, description={"Record Type to load (fuzzy tables only)"})
    private String tableName;
    @CommandLine.Option(names={"-o", "--options"}, required=false, description={"Load options"})
    private String propertiestr;
    @CommandLine.Option(names={"-pbp", "--postBatchPipeline"}, required=false, description={"Post Batch Pipeline"})
    private String postBatchPipeline;
    @CommandLine.Option(names={"-plp", "--postLoadPipeline"}, required=false, description={"Post Load Pipeline"})
    private String postLoadPipeline;
    @CommandLine.Option(names={"-q", "--quiet"}, description={"Be less verbose"})
    private boolean quiet = false;
    private boolean terminate = false;

    public MonsterLoadCLI() throws NoDatabaseException {
    }

    public MonsterLoadCLI(String host, int port, String username, String password, String collection, String database, String fileName, String tableName, String options, String postBatchPipeline, String postLoadPipeline, boolean quiet, boolean terminate) throws NoDatabaseException {
        this.host = host;
        this.collection = collection;
        this.port = port;
        this.username = username;
        this.password = password;
        this.db = database;
        this.filename = fileName;
        this.tableName = tableName;
        this.propertiestr = options;
        this.postBatchPipeline = postBatchPipeline;
        this.postLoadPipeline = postLoadPipeline;
        this.quiet = quiet;
        this.terminate = terminate;
        new Thread(this).start();
    }

    public static void main(String ... args) {
        CommandLine.run((Runnable)new MonsterLoadCLI(), (PrintStream)System.err, (String[])args);
    }

    @Override
    public void run() {
        block23: {
            try {
                TizaReader tiza;
                this.connect(this.host, this.port, this.username, this.password);
                this.useDatabase(this.db);
                this.useCollection(this.collection);
                System.out.println(this.propertiestr);
                Document properties = Document.parse(this.propertiestr);
                BasicDBList postBatch = null;
                if (this.postBatchPipeline != null) {
                    postBatch = (BasicDBList)Document.parseListOrDoc(this.postBatchPipeline);
                }
                BasicDBList postLoad = null;
                if (this.postLoadPipeline != null) {
                    postLoad = (BasicDBList)Document.parseListOrDoc(this.postLoadPipeline);
                }
                Properties props = new Properties();
                if (properties != null) {
                    props.putAll((Map<?, ?>)properties.toMap());
                }
                if ((tiza = TizaReader.createReader((String)this.filename, (Properties)props, (String)"")) == null || !tiza.isValid()) break block23;
                try {
                    Map record;
                    long start = System.currentTimeMillis();
                    ITable table = null;
                    if (this.tableName == null) {
                        HashMap<String, String> headings = new HashMap<String, String>();
                        for (String heading : tiza.getHeadings()) {
                            String[] p = heading.split("\\(");
                            String type = "text";
                            if (p.length > 1 && (type = p[1].replaceAll("\\)", "")).equalsIgnoreCase("Group")) {
                                type = "Structure";
                            }
                            headings.put(p[0].trim(), type.trim());
                        }
                        table = new Table();
                        for (String heading : headings.keySet()) {
                            TableColumn tc = new TableColumn();
                            tc.setColName(heading);
                            tc.setDisplayType((String)headings.get(heading));
                            table.addColumn(tc);
                        }
                        table.init();
                    } else {
                        Document tableDoc = this.getTable(this.tableName);
                        if (tableDoc != null) {
                            table = (ITable)tableDoc.toObject(Table.class);
                        }
                        if (table == null) {
                            System.out.println("Unknown table " + this.tableName);
                            return;
                        }
                    }
                    tiza = TizaReader.createReader((String)this.filename, (Properties)props, (String)"");
                    System.out.println(new Date().toLocaleString() + " loadFile Process starting  (" + this.filename + ")");
                    ArrayList<Document> records = new ArrayList<Document>(1000);
                    int count = 0;
                    while ((record = tiza.readNext()) != null) {
                        ++count;
                        Document doc = Node.expandDoc((Map)record, (ITable)table);
                        doc.append("Table", this.tableName);
                        records.add(doc);
                        if (count % 1000 != 0) continue;
                        this.saveMany(records);
                        if (postBatch != null) {
                            this.postBatch(postBatch.toList(), records);
                        }
                        records = new ArrayList(1000);
                        count = 0;
                    }
                    if (records.size() > 0) {
                        this.saveMany(records);
                        if (postBatch != null) {
                            this.postBatch(postBatch.toList(), records);
                        }
                    }
                    if (!this.quiet) {
                        System.out.println(new Date().toLocaleString() + " loadFile Process completed (" + this.filename + ") in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    if (postLoad != null) {
                        long startpl = System.currentTimeMillis();
                        if (!this.quiet) {
                            System.out.println(new Date().toLocaleString() + " Post Load Pipeline Commencing...");
                        }
                        this.aggregate(records, postLoad.toList()).forEach(d -> System.out.println(((Document)d).toJson()));
                        if (!this.quiet) {
                            System.out.println(new Date().toLocaleString() + " Post Load Pipeline Completed (" + this.filename + ") in " + (System.currentTimeMillis() - startpl) + "ms");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.terminate) break block23;
                System.exit(-1);
            }
        }
        if (this.terminate) {
            System.exit(0);
        }
    }

    private void postBatch(List<Document> postBatch, List<Document> records) {
        if (postBatch != null) {
            long startpl = System.currentTimeMillis();
            this.aggregate(records, postBatch).forEach(d -> System.out.println(d.toJson()));
            if (!this.quiet) {
                System.out.println(new Date().toLocaleString() + " Post Batch Completed in " + (System.currentTimeMillis() - startpl) + " ms");
            }
        }
    }
}

