/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.monster.db.Container;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class Session {
    protected static final long MAXAGE = 60000L;
    Map<Long, DBCursor> cursors = new HashMap<Long, DBCursor>();
    Map<Long, Long> cursorAge = new HashMap<Long, Long>();
    Map<Long, AtomicBoolean> cursorActive = new HashMap<Long, AtomicBoolean>();
    Thread ticker = null;
    private long id;
    public long lastTouch;
    private boolean remoteView;
    private List<Document> roles;
    private User user;
    private String lastStatement;

    public Session(final long id, final User user, List<Document> roles) {
        this.id = id;
        this.user = user;
        this.roles = roles;
        this.lastTouch = System.currentTimeMillis();
        this.ticker = new Thread(new Runnable(){

            @Override
            public void run() {
                if (user != null) {
                    System.out.println("Session Connected " + id + " as " + user.identifier);
                } else {
                    System.out.println("Session Connected " + id);
                }
                while (Session.this.cursors.size() != -1) {
                    try {
                        for (long cur : Session.this.cursorAge.keySet()) {
                            if (!Session.this.cursors.containsKey(cur) || Session.this.cursorAge.get(cur) + 60000L >= System.currentTimeMillis()) continue;
                            if (!Session.this.cursorActive.get(cur).get()) {
                                Session.this.cursors.remove(cur);
                                continue;
                            }
                            Session.this.cursorAge.put(id, System.currentTimeMillis());
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        System.out.println("Session ticker terminated " + id);
                    }
                }
            }
        });
        this.ticker.start();
    }

    public Session(long sessionid) {
        this(sessionid, null, null);
    }

    public DBCursor getCursor(long cursor) {
        this.lastTouch = System.currentTimeMillis();
        return this.cursors.get(cursor);
    }

    public void removeCursor(long cursor) {
        this.lastTouch = System.currentTimeMillis();
        DBCursor c = this.cursors.get(cursor);
        if (c != null) {
            c.destroy();
        }
        this.cursors.remove(cursor);
    }

    public void disconnect() {
        this.cursors.clear();
        this.ticker.interrupt();
        this.ticker = null;
        System.out.println("Session disconnected " + this.id);
    }

    public long execute(ICollection coll, String command2) {
        this.lastTouch = -1L;
        DBCursor cursor = coll.executeCommand(command2, this.user, this);
        return this.addCursor(cursor, command2);
    }

    public long execute(Database db, String command2) {
        this.lastTouch = -1L;
        db.setRemoteView(this.remoteView);
        DBCursor cursor = db.executeCommand(command2, this.user, this);
        return this.addCursor(cursor, command2);
    }

    public long execute(Container client, String command2) {
        this.lastTouch = -1L;
        client.setRemoteView(this.remoteView);
        DBCursor cursor = client.executeCommand(command2, this.user, this);
        return this.addCursor(cursor, command2);
    }

    public long addCursor(DBCursor cursor, String statement) {
        this.lastTouch = System.currentTimeMillis();
        this.lastStatement = statement;
        long id = UUID.randomUUID().getLeastSignificantBits();
        this.cursorAge.put(id, System.currentTimeMillis());
        AtomicBoolean ab = new AtomicBoolean(false);
        if (cursor != null) {
            cursor.setInProgress(ab);
            cursor.setStatement(statement);
        }
        this.cursors.put(id, cursor);
        this.cursorActive.put(id, ab);
        return id;
    }

    public void isRemote(boolean remoteView) {
        this.remoteView = remoteView;
    }
}

