/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.Role;
import com.entitystream.monster.db.User;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Users {
    public List<User> users = new ArrayList<User>();
    public Map<String, Document> roles = new HashMap<String, Document>();

    public static Users build(String filename) {
        if (filename != null) {
            filename = filename.replaceAll("'", "");
        }
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        return new Users().load(filename);
    }

    public Map<String, Document> getRoles() {
        return this.roles;
    }

    public Users load(String filename) {
        if (filename != null) {
            File file = new File(filename);
            if (file.exists()) {
                try {
                    Gson gson = new Gson();
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    this.users = new ArrayList<User>();
                    br.lines().forEach(s -> {
                        if (s != null) {
                            Role role;
                            if (s.indexOf("identifier") != -1) {
                                User user = (User)gson.fromJson(s, User.class);
                                if (user != null) {
                                    this.users.add(user);
                                }
                            } else if (s.indexOf("role") != -1 && (role = (Role)gson.fromJson(s, Role.class)) != null) {
                                this.roles.put(role.getRole(), role.getAccessRights());
                            }
                        }
                    });
                    System.out.println("Initialised " + this.users.size() + " users and " + this.roles.size() + " roles, anonymous logins are disabled");
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            return null;
        }
        return this;
    }

    public User ok(String name, String password) {
        for (User u : this.users) {
            if (!u.getIdentifier().equalsIgnoreCase(name) || !u.getPassword().equals(password)) continue;
            return u;
        }
        return null;
    }
}

