/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.external;

import au.com.bytecode.opencsv.CSVReader;
import com.entitystream.monster.db.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.stream.Stream;

public class ExternalData {
    public static Stream<Document> readFile(Document rfopt, Stream<Document> in, Document options) {
        try {
            File f;
            if (rfopt.containsKey("filename") && !(f = new File(rfopt.getString("filename"))).exists()) {
                return null;
            }
            if (rfopt.containsKey("filename")) {
                if (!rfopt.containsKey("type") || rfopt.getString("type").equalsIgnoreCase("JSON")) {
                    BufferedReader reader = new BufferedReader(new FileReader(rfopt.getString("filename")));
                    return ((Stream)reader.lines().parallel()).map(line -> {
                        Document out = Document.parse(line);
                        return out;
                    });
                }
                if (rfopt.getString("type").equalsIgnoreCase("CSV")) {
                    CSVReader csv = null;
                    String charset = "UTF8";
                    if (rfopt.containsKey("charset")) {
                        charset = rfopt.getString("charset");
                    }
                    csv = rfopt.containsKey("delimiter") && rfopt.containsKey("quote") ? new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(rfopt.getString("filename")), charset), rfopt.getString("delimiter").charAt(0), rfopt.getString("quote").charAt(0)) : (rfopt.containsKey("delimiter") ? new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(rfopt.getString("filename")), charset), rfopt.getString("delimiter").charAt(0)) : new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(rfopt.getString("filename")), charset)));
                    String[] columns = csv.readNext();
                    ArrayList<String> cols = new ArrayList<String>();
                    for (String col : columns) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : col.getBytes()) {
                            if (b <= 0) continue;
                            sb.append((char)b);
                        }
                        col = sb.toString();
                        cols.add(col);
                    }
                    return csv.readAll().parallelStream().map(dcolumns -> {
                        Document out = new Document();
                        int pos = -1;
                        for (String col : cols) {
                            if (((String[])dcolumns).length <= ++pos) continue;
                            out.append(col, dcolumns[pos]);
                        }
                        return out;
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Stream writeFile(Document rfopt, Stream<Document> in, Document options) {
        try {
            boolean overwrite = true;
            if (rfopt.containsKey("overwrite")) {
                overwrite = rfopt.getBoolean("overwrite", true);
            }
            if (rfopt.containsKey("filename")) {
                File f = new File(rfopt.getString("filename"));
                PrintWriter pw = f.exists() && overwrite ? new PrintWriter(rfopt.getString("filename")) : (f.exists() && !overwrite ? new PrintWriter(new FileOutputStream(new File(rfopt.getString("filename")), true)) : new PrintWriter(rfopt.getString("filename")));
                if (!rfopt.containsKey("type") || rfopt.getString("type").equalsIgnoreCase("JSON")) {
                    ((Stream)in.sequential()).forEach(doc -> pw.println(doc.toJson()));
                } else if (rfopt.containsKey("type") && rfopt.getString("type").equalsIgnoreCase("CSV")) {
                    ((Stream)in.sequential()).forEach(doc -> pw.println(doc.toCSV()));
                }
                pw.flush();
                pw.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Stream readJDBC(Document settings, Stream<Document> in, Document options) {
        System.out.println("readJDBC Not supported in community edition");
        return Stream.builder().add(new Document("Error", "readJDBC Not supported in community edition")).build();
    }

    public static Stream readActiveMQ(Document settings, Stream<Document> in, Document options) {
        System.out.println("readActiveMQ Not supported in community edition");
        return Stream.builder().add(new Document("Error", "readActiveMQ Not supported in community edition")).build();
    }

    public static Stream writeActiveMQ(Document settings, Stream<Document> in, Document options) {
        System.out.println("writeActiveMQ Not supported in community edition");
        return Stream.builder().add(new Document("Error", "writeActiveMQ  Not supported in community edition")).build();
    }
}

