/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.external;

import com.entitystream.monster.db.Document;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class RestAPI {
    public static Stream<Document> executeGet(Document restGetDefn, Stream<Document> in, Document options) {
        Stream<Document> out = null;
        if (restGetDefn != null && restGetDefn.containsKey("url")) {
            if (restGetDefn.containsKey("url")) {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpClientContext context = new HttpClientContext();
                HttpGet request = new HttpGet(restGetDefn.getString("url"));
                if (restGetDefn.containsKey("headers")) {
                    request.setHeaders(RestAPI.getHeaders(restGetDefn.getAsDocument("headers")));
                }
                try {
                    HttpResponse response = client.execute((HttpUriRequest)request);
                    HttpEntity entity = response.getEntity();
                    Document headers = RestAPI.getHeaders(response);
                    InputStream inputStream = entity.getContent();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    out = reader.lines().map(s -> {
                        Document ret = Document.parse(s);
                        return ret;
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            out = in.map(i -> {
                if (i.containsKey("url")) {
                    CloseableHttpClient client = HttpClientBuilder.create().build();
                    HttpClientContext context = new HttpClientContext();
                    HttpGet request = new HttpGet(i.getString("url"));
                    if (i.containsKey("headers")) {
                        request.setHeaders(RestAPI.getHeaders(i.getAsDocument("headers")));
                    } else if (restGetDefn != null && restGetDefn.containsKey("headers")) {
                        request.setHeaders(RestAPI.getHeaders(restGetDefn.getAsDocument("headers")));
                    }
                    try {
                        HttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)context);
                        Document headers = RestAPI.getHeaders(response);
                        HttpEntity entity = response.getEntity();
                        InputStream inputStream = entity.getContent();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        return reader.lines().map(s -> {
                            Document ret = Document.parse(s);
                            return ret;
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }).flatMap(c -> c);
        }
        return out;
    }

    private static Header[] getHeaders(Document header) {
        Header[] headers = new Header[header.size()];
        int i = 0;
        for (Object key : header.keySet()) {
            headers[i++] = new BasicHeader((String)key, header.getString((String)key));
        }
        return headers;
    }

    private static Document getHeaders(HttpResponse response) {
        Document ret = new Document();
        for (Header h : response.getAllHeaders()) {
            ret.append(h.getName(), h.getValue());
        }
        return ret;
    }
}

