/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.morphia;

import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.morphia.Datastore;
import com.entitystream.morphia.FindOptions;
import com.entitystream.morphia.Query;
import com.entitystream.morphia.UpdateOperations;
import com.entitystream.morphia.annotations.Entity;
import com.entitystream.morphia.annotations.Id;
import com.entitystream.morphia.annotations.Transient;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class MonsterDatastore
implements Datastore {
    MonsterClient client = null;
    String packageNme;

    public MonsterDatastore(MonsterClient monClient, String packageNme) {
        this.client = monClient;
        this.packageNme = packageNme;
    }

    @Override
    public MonsterClient getMonsterDB() {
        return this.client;
    }

    @Override
    public <T> Query createQuery(Class<T> class1) {
        return new Query<Class<T>>(class1, this);
    }

    @Override
    public <T> T save(T entity) {
        Document out = this.convert(entity);
        String type = entity.getClass().getSimpleName();
        Entity ann = entity.getClass().getAnnotation(Entity.class);
        if (ann != null) {
            type = ann.value();
        }
        Document ret = this.client.useCollection(type).insertOne(out);
        return (T)this.convert(ret, entity.getClass());
    }

    private <T> Object convert(Document doc, Class<T> clazz) {
        Object object = null;
        try {
            object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Transient istrans = field.getAnnotation(Transient.class);
                if (istrans != null && istrans.value() || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                String name = field.getName();
                SerializedName prop = field.getAnnotation(SerializedName.class);
                if (prop != null) {
                    name = prop.value();
                }
                Object value = doc.get(name);
                try {
                    if (value == null) continue;
                    if (value instanceof Document) {
                        field.set(object, this.convert((Document)value, field.getType()));
                        continue;
                    }
                    if (value instanceof List) {
                        Class listOfClass = Object.class;
                        if (field.getGenericType() instanceof ParameterizedType) {
                            listOfClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        }
                        ArrayList<Object> newlist = new ArrayList<Object>();
                        for (Object item : (List)value) {
                            if (listOfClass.isPrimitive()) {
                                newlist.add(item);
                                continue;
                            }
                            if (!(item instanceof Document)) continue;
                            newlist.add(this.convert((Document)item, listOfClass));
                        }
                        field.set(object, newlist);
                        continue;
                    }
                    if (!field.getType().isAssignableFrom(value.getClass())) {
                        Class<?> valClass = value.getClass();
                        Class<?> fieldClass = field.getType();
                        if (fieldClass.equals(Long.TYPE)) {
                            if (valClass.equals(Long.class)) {
                                field.set(object, (long)((Long)value));
                                continue;
                            }
                            if (valClass.equals(Integer.class)) {
                                field.set(object, ((Integer)value).longValue());
                                continue;
                            }
                            if (!valClass.equals(Integer.TYPE)) continue;
                            field.set(object, Integer.valueOf((Integer)value).longValue());
                            continue;
                        }
                        if (fieldClass.equals(Long.class)) {
                            if (valClass.equals(Long.TYPE)) {
                                field.set(object, (long)((Long)value));
                                continue;
                            }
                            if (valClass.equals(Integer.TYPE)) {
                                field.set(object, (Integer)value);
                                continue;
                            }
                            if (!valClass.equals(Integer.class)) continue;
                            field.set(object, Long.valueOf(((Integer)value).intValue()).intValue());
                            continue;
                        }
                        if (fieldClass.equals(Integer.class)) {
                            if (valClass.equals(Long.class)) {
                                field.set(object, ((Long)value).intValue());
                                continue;
                            }
                            if (valClass.equals(Integer.TYPE)) {
                                field.set(object, (int)((Integer)value));
                                continue;
                            }
                            if (!valClass.equals(Long.TYPE)) continue;
                            field.set(object, Long.valueOf((Long)value).intValue());
                            continue;
                        }
                        if (fieldClass.equals(Integer.TYPE)) {
                            if (valClass.equals(Long.class)) {
                                field.set(object, ((Long)value).intValue());
                                continue;
                            }
                            if (valClass.equals(Integer.class)) {
                                field.set(object, (int)((Integer)value));
                                continue;
                            }
                            if (!valClass.equals(Long.TYPE)) continue;
                            field.set(object, Long.valueOf((Long)value).intValue());
                            continue;
                        }
                        if (fieldClass.equals(Boolean.TYPE)) {
                            if (!valClass.equals(Boolean.class)) continue;
                            field.set(object, (boolean)((Boolean)value));
                            continue;
                        }
                        if (fieldClass.equals(Boolean.class)) {
                            if (!valClass.equals(Boolean.TYPE)) continue;
                            field.set(object, (boolean)((Boolean)value));
                            continue;
                        }
                        if (fieldClass.isEnum()) {
                            if (!valClass.equals(String.class)) continue;
                            Class<?> e = field.getType();
                            field.set(object, Enum.valueOf(e, (String)value));
                            continue;
                        }
                        if (fieldClass.equals(Date.class)) {
                            if (value instanceof Date) {
                                field.set(object, value);
                                continue;
                            }
                            field.set(object, Document.fromISO8601UTC(value));
                            continue;
                        }
                        field.set(object, field.getType().cast(value));
                        continue;
                    }
                    field.set(object, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    private Document convert(Object entity) {
        Document out = new Document();
        for (Field field : entity.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Transient istrans = field.getAnnotation(Transient.class);
            if (istrans != null && istrans.value()) continue;
            String name = field.getName();
            SerializedName prop = field.getAnnotation(SerializedName.class);
            if (prop != null) {
                name = prop.value();
            }
            try {
                ArrayList<Document> newlist;
                Object value = field.get(entity);
                if (field.getType().isPrimitive() || value == null || field.getType().isAssignableFrom(String.class) || field.getType().isAssignableFrom(Number.class) || field.getType().isAssignableFrom(Boolean.class)) {
                    out.append(name, value);
                    continue;
                }
                if (field.getType().isAssignableFrom(Date.class)) {
                    out.append(name, Document.toISO8601UTC((Date)value));
                    continue;
                }
                if (field.getType().isEnum()) {
                    out.append(name, value.toString());
                    continue;
                }
                if (field.getType().isArray()) {
                    newlist = new ArrayList<Document>();
                    for (int i = 0; i < ((Object[])value).length; ++i) {
                        newlist.add(this.convert(((Object[])value)[i]));
                    }
                    out.append(name, value.toString());
                    continue;
                }
                if (field.getType().isAssignableFrom(List.class)) {
                    newlist = new ArrayList();
                    for (Object item : (List)value) {
                        newlist.add(this.convert(item));
                    }
                    out.append(name, newlist);
                    continue;
                }
                if (field.getType().isAssignableFrom(Map.class) && value instanceof Map) {
                    out.append(name, value);
                    continue;
                }
                if (field.getType().isAssignableFrom(Document.class) && value instanceof Document) {
                    out.append(name, value);
                    continue;
                }
                if (field.getType().isAssignableFrom(Document.class) && value instanceof Map) {
                    out.append(name, new Document(value));
                    continue;
                }
                out.append(name, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    private String getIdField(Class forType) {
        for (Field field : forType.getFields()) {
            field.setAccessible(true);
            Transient istrans = field.getAnnotation(Transient.class);
            if (istrans != null && istrans.value()) continue;
            String name = field.getName();
            if (field.getAnnotation(Id.class) == null) continue;
            return name;
        }
        return null;
    }

    @Override
    public <T> UpdateOperations createUpdateOperations(Class<T> clazz) {
        return new UpdateOperations();
    }

    @Override
    public void update(Query q, UpdateOperations up) {
        this.client.updateMany(q.getQuery(), new Document("$set", up.getOperations()), up.getOptions());
    }

    @Override
    public <T> T findAndDelete(Query q) {
        Document r = this.client.findOneAndDelete(q.getQuery());
        return (T)this.convert(r, (Class)q.getType());
    }

    @Override
    public <T> Query<T> find(Class<T> class1) {
        return new Query<Class<T>>(class1, this);
    }

    @Override
    public <T> Query<T> find(Class<T> class1, String string, String value) {
        Query<Class<T>> q = new Query<Class<T>>(class1, this);
        return q.criteria(string).equal(value);
    }

    @Override
    public <T> T delete(T entity) {
        Document ret = this.client.deleteOne(this.convert(entity));
        return (T)this.convert(ret, entity.getClass());
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(MonsterDatastore.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(MonsterDatastore.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    @Override
    public void ensureIndexes() {
        try {
            for (Class clazz : MonsterDatastore.getClasses(this.packageNme)) {
                if (!clazz.isAnnotationPresent(Entity.class)) continue;
                String id = this.getIdField(clazz);
                String[] types = clazz.toString().split("\\.");
                String type = types[types.length - 1];
                Entity ann = clazz.getAnnotation(Entity.class);
                if (ann != null) {
                    type = ann.value();
                }
                this.client.useCollection(type);
                this.client.createIndex(new Document(id, 1), new Document("name", id + "_1").append("unique", true));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public <T> List<T> find(Query<T> query) {
        ArrayList<Object> out = new ArrayList<Object>();
        String fullName = query.getType().toString().replaceAll("class ", "");
        String[] types = fullName.split("\\.");
        String type = types[types.length - 1];
        Entity ann = query.getType().getClass().getAnnotation(Entity.class);
        if (ann != null) {
            type = ann.value();
        }
        this.client.useCollection(type);
        Class<?> clazz = (Class<?>)query.getType();
        try {
            this.getClass();
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Document d : this.client.find(query.getQuery()).sort(query.getOrder())) {
            out.add(this.convert(d, clazz));
        }
        return out;
    }

    public <T> List<T> find(Query<T> query, FindOptions options) {
        ArrayList<Object> out = new ArrayList<Object>();
        long l = Long.MAX_VALUE;
        if (options.getLimit() > -1L) {
            l = options.getLimit();
        }
        String fullName = query.getType().toString().replaceAll("class ", "");
        Class<?> clazz = (Class<?>)query.getType();
        try {
            this.getClass();
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Document d : this.client.find(query.getQuery()).limit(l).sort(query.getOrder())) {
            out.add(this.convert(d, clazz));
        }
        return out;
    }

    @Override
    public <T> T replace(Query q, T entity) {
        Document r = this.client.findOneAndReplace(q.getQuery(), this.convert(entity));
        return (T)this.convert(r, (Class)q.getType());
    }
}

