/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api;

import com.envision.eeop.api.EnvisionClient;
import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionApiException;
import com.envision.eeop.api.exception.EnvisionIOException;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.JsonParser;
import com.envision.eeop.api.util.Sign;
import com.envision.eeop.api.util.WebUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvisionDefaultClient
implements EnvisionClient {
    private static Logger logger = LoggerFactory.getLogger(EnvisionDefaultClient.class);
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private int connectTimeout = 30000;
    private int readTimeout = 30000;

    public EnvisionDefaultClient(String serverUrl, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public EnvisionDefaultClient(String serverUrl, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Override
    public <T extends EnvisionResponse> T execute(EnvisionRequest<T> request) throws EnvisionApiException {
        return this.doExecute(request, null);
    }

    @Override
    public <T extends EnvisionResponse> T execute(EnvisionRequest<T> request, String token) throws EnvisionApiException {
        return this.doExecute(request, token);
    }

    protected <T extends EnvisionResponse> T doExecute(EnvisionRequest<T> request, String token) throws EnvisionApiException {
        try {
            request.check();
        }
        catch (EnvisionRuleException e) {
            logger.error("Check Parameters Failed!", (Throwable)e);
            throw e;
        }
        return this.doPost(request, token);
    }

    private <T extends EnvisionResponse> T doPost(EnvisionRequest<T> request, String token) throws EnvisionApiException {
        Map<String, String> textParams = request.getTextParams();
        if (token != null && !token.isEmpty()) {
            textParams.put("token", token);
        }
        String url = this.makeUrl(textParams, request.getApiMethodName());
        System.out.println(url);
        String ret = null;
        try {
            ret = WebUtils.doPost(url, textParams, "UTF-8", this.connectTimeout, this.readTimeout);
            logger.info("result:" + ret);
        }
        catch (IOException e) {
            logger.error("Execute Post Request Failed!", (Throwable)e);
            throw new EnvisionIOException(e);
        }
        EnvisionResponse response = (EnvisionResponse)JsonParser.fromJson(ret, request.getResponseClass());
        response.setBody(ret);
        logger.debug(response.toString());
        return (T)response;
    }

    private String makeUrl(Map<String, String> textParams, String apiName) {
        String sign = Sign.sign(this.appKey, this.appSecret, textParams);
        StringBuilder url = new StringBuilder(this.serverUrl);
        url.append(apiName);
        url.append("?");
        url.append("appKey=");
        url.append(this.appKey);
        url.append("&sign=");
        url.append(sign);
        return url.toString();
    }
}

