/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api;

import com.envision.eeop.api.EnvisionDefaultClient;
import com.envision.eeop.api.EnvisionPaginationRequest;
import com.envision.eeop.api.EnvisionPaginationResponse;
import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.EnvisionSkipAndLimitRequest;
import com.envision.eeop.api.EnvisionSkipAndLimitResponse;
import com.envision.eeop.api.exception.EnvisionApiException;

public class EnvisionDefaultPaginationClient
extends EnvisionDefaultClient {
    private int pageSize = 3000;
    private int executeTimeout = Integer.MAX_VALUE;

    public EnvisionDefaultPaginationClient(String serverUrl, String appKey, String appSecret) {
        super(serverUrl, appKey, appSecret);
    }

    public EnvisionDefaultPaginationClient(String serverUrl, String appKey, String appSecret, int pageSize) {
        super(serverUrl, appKey, appSecret);
        this.pageSize = pageSize;
    }

    public EnvisionDefaultPaginationClient(String serverUrl, String appKey, String appSecret, int pageSize, int executeTimeout) {
        super(serverUrl, appKey, appSecret);
        this.pageSize = pageSize;
        this.executeTimeout = executeTimeout;
    }

    @Override
    public <T extends EnvisionResponse> T execute(EnvisionRequest<T> request) throws EnvisionApiException {
        if (request instanceof EnvisionPaginationRequest) {
            return this.doPaginationRequest((EnvisionPaginationRequest)request, null);
        }
        if (request instanceof EnvisionSkipAndLimitRequest) {
            return this.doSkipAndLimitRequest((EnvisionSkipAndLimitRequest)request, null);
        }
        throw new EnvisionApiException(request.getApiMethodName() + " does not support pagination.");
    }

    @Override
    public <T extends EnvisionResponse> T execute(EnvisionRequest<T> request, String token) throws EnvisionApiException {
        if (request instanceof EnvisionPaginationRequest) {
            return this.doPaginationRequest((EnvisionPaginationRequest)request, token);
        }
        if (request instanceof EnvisionSkipAndLimitRequest) {
            return this.doSkipAndLimitRequest((EnvisionSkipAndLimitRequest)request, token);
        }
        throw new EnvisionApiException(request.getApiMethodName() + " does not support pagination.");
    }

    private <T extends EnvisionPaginationResponse> T doPaginationRequest(EnvisionPaginationRequest<T> request, String token) throws EnvisionApiException {
        EnvisionPaginationResponse partialResponse;
        long startTime = System.currentTimeMillis();
        int pageNo = 0;
        EnvisionPaginationResponse response = null;
        request.setPageSize(this.pageSize);
        do {
            request.setPageNo(pageNo);
            partialResponse = (EnvisionPaginationResponse)super.doExecute(request, token);
            if (partialResponse.isSuccess()) {
                response = response == null ? partialResponse : response.merge(partialResponse);
            } else {
                throw new EnvisionApiException(request.getApiMethodName() + " failed at page no.: " + pageNo + ", page size: " + this.pageSize + " , status: " + partialResponse.getStatus() + ", msg: " + partialResponse.getMsg() + " / " + partialResponse.getSubmsg());
            }
            long currTime = System.currentTimeMillis();
            if (currTime - startTime > (long)this.executeTimeout) {
                throw new EnvisionApiException(request.getApiMethodName() + " expired, limit: " + this.executeTimeout + ", actural: " + (currTime - startTime));
            }
            ++pageNo;
        } while (!partialResponse.isLastPage());
        return (T)response;
    }

    private <T extends EnvisionSkipAndLimitResponse> T doSkipAndLimitRequest(EnvisionSkipAndLimitRequest<T> request, String token) throws EnvisionApiException {
        EnvisionSkipAndLimitResponse partialResponse;
        long startTime = System.currentTimeMillis();
        String exclusiveFrom = null;
        EnvisionSkipAndLimitResponse response = null;
        request.setPageSize(this.pageSize);
        do {
            request.setExclusiveFrom(exclusiveFrom);
            partialResponse = (EnvisionSkipAndLimitResponse)super.doExecute(request, token);
            if (partialResponse.isSuccess()) {
                response = response == null ? partialResponse : response.merge(partialResponse);
            } else {
                throw new EnvisionApiException(request.getApiMethodName() + " failed from: " + exclusiveFrom + ", page size: " + this.pageSize);
            }
            long currTime = System.currentTimeMillis();
            if (currTime - startTime > (long)this.executeTimeout) {
                throw new EnvisionApiException(request.getApiMethodName() + " expired, limit: " + this.executeTimeout + ", actural: " + (currTime - startTime));
            }
            exclusiveFrom = partialResponse.getLastElement();
        } while (!partialResponse.isLastPage() && exclusiveFrom != null);
        return (T)response;
    }
}

