/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api;

import com.envision.eeop.api.EnvisionStreamClient;
import com.envision.eeop.api.exception.EnvisionApiException;
import com.envision.eeop.api.request.AbstractEnvisionStreamRequest;
import com.envision.eeop.api.util.Sign;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvisionDefaultStreamClient
implements EnvisionStreamClient {
    private static Logger logger = LoggerFactory.getLogger(EnvisionDefaultStreamClient.class);
    private String serverUrl;
    private String appKey;
    private String appSecret;

    public EnvisionDefaultStreamClient(String serverUrl, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Override
    public boolean download(AbstractEnvisionStreamRequest request, String token) throws EnvisionApiException, IOException {
        Map<String, String> textParams = request.getTextParams();
        if (token != null && !token.isEmpty()) {
            textParams.put("token", token);
        }
        String url = this.makeUrl(textParams, request.getApiMethodName());
        CloseableHttpClient client = HttpClients.createDefault();
        HttpResponse response = this.execute(client, url, null, textParams);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            return false;
        }
        InputStream is = response.getEntity().getContent();
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(request.getFile()));
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = bis.read(b, 0, b.length)) != -1) {
            bos.write(b, 0, len);
        }
        bis.close();
        bos.close();
        client.close();
        return true;
    }

    @Override
    public boolean upload(AbstractEnvisionStreamRequest request, String token) throws EnvisionApiException, IOException {
        Map<String, String> textParams = request.getTextParams();
        if (token != null && !token.isEmpty()) {
            textParams.put("token", token);
        }
        String url = this.makeUrl(textParams, request.getApiMethodName());
        CloseableHttpClient client = HttpClients.createDefault();
        HttpResponse response = this.execute(client, url, request.getFile(), textParams);
        return response != null && response.getStatusLine().getStatusCode() == 200;
    }

    private HttpResponse execute(CloseableHttpClient client, String url, File file, Map<String, String> stringBodys) throws IOException {
        HttpPost post = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (file != null) {
            FileBody fileBody = new FileBody(file, ContentType.DEFAULT_BINARY);
            builder.addPart("data", (ContentBody)fileBody);
        }
        if (stringBodys != null) {
            for (String key : stringBodys.keySet()) {
                StringBody stringBody = new StringBody(stringBodys.get(key), ContentType.APPLICATION_FORM_URLENCODED);
                builder.addPart(key, (ContentBody)stringBody);
            }
        }
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        return response;
    }

    private String makeUrl(Map<String, String> textParams, String apiName) {
        String sign = Sign.sign(this.appKey, this.appSecret, textParams);
        StringBuilder url = new StringBuilder(this.serverUrl);
        url.append(apiName);
        url.append("?");
        url.append("appKey=");
        url.append(this.appKey);
        url.append("&sign=");
        url.append(sign);
        return url.toString();
    }
}

