/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api;

import com.envision.eeop.api.EnvisionPaginationResponse;
import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public abstract class EnvisionPaginationRequest<T extends EnvisionPaginationResponse>
implements EnvisionRequest<T> {
    protected int pageNo = 0;
    protected int pageSize = 0;

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected Map<String, String> getPaginationParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        if (this.pageSize > 0) {
            txtParams.put("page_no", String.valueOf(this.pageNo));
            txtParams.put("page_size", String.valueOf(this.pageSize));
        }
        return txtParams;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkRange(this.pageNo, 0, Integer.MAX_VALUE, "page_no");
        RuleCheckUtils.checkRange(this.pageSize, 0, 1000, "page_size");
    }
}

