/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionSkipAndLimitResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public abstract class EnvisionSkipAndLimitRequest<T extends EnvisionSkipAndLimitResponse>
implements EnvisionRequest<T> {
    protected int pageSize = 0;
    protected String exclusiveFrom;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getExclusiveFrom() {
        return this.exclusiveFrom;
    }

    public void setExclusiveFrom(String exclusiveFrom) {
        this.exclusiveFrom = exclusiveFrom;
    }

    protected Map<String, String> getPaginationParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        if (this.pageSize > 0) {
            txtParams.put("page_size", String.valueOf(this.pageSize));
        }
        if (this.exclusiveFrom != null) {
            txtParams.put("exclusive_from", this.exclusiveFrom);
        }
        return txtParams;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkRange(this.pageSize, 0, 1000, "page_size");
    }
}

