/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.domain;

import com.envision.eeop.api.domain.DomainSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DomainInfo
implements Serializable {
    private static final long serialVersionUID = 6781814600652725558L;
    private List<DomainSchema> schemas;
    private List<DomainSchema> passthroughPoints;
    private int domainID;
    private String domainName;

    public DomainInfo() {
    }

    public DomainInfo(List<DomainSchema> schemas, List<DomainSchema> passthroughPoints, int domainID, String domainName) {
        this.schemas = schemas;
        this.passthroughPoints = passthroughPoints;
        this.domainID = domainID;
        this.domainName = domainName;
    }

    public List<DomainSchema> getSchemas() {
        int size = (this.schemas != null ? this.schemas.size() : 0) + (this.passthroughPoints != null ? this.passthroughPoints.size() : 0);
        ArrayList<DomainSchema> allSchemas = new ArrayList<DomainSchema>(size);
        if (this.schemas != null) {
            allSchemas.addAll(this.schemas);
        }
        if (this.passthroughPoints != null) {
            allSchemas.addAll(this.passthroughPoints);
        }
        return allSchemas;
    }

    public List<DomainSchema> getNonPassthroughSchemas() {
        return this.schemas;
    }

    public List<DomainSchema> getPassthroughPoints() {
        return this.passthroughPoints;
    }

    public void setNonPassthroughSchemas(List<DomainSchema> schemas) {
        this.schemas = schemas;
    }

    public void setPassthroughPoints(List<DomainSchema> passthroughPoints) {
        this.passthroughPoints = passthroughPoints;
    }

    public void setSchemas(List<DomainSchema> schemas) {
        this.schemas = schemas;
    }

    public int getDomainID() {
        return this.domainID;
    }

    public void setDomainID(int domainID) {
        this.domainID = domainID;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public static DomainInfo merge(List<DomainInfo> domainInfos) {
        if (domainInfos == null || domainInfos.isEmpty()) {
            return null;
        }
        DomainInfo result = new DomainInfo();
        result.domainID = domainInfos.iterator().next().domainID;
        result.domainName = domainInfos.iterator().next().domainName;
        HashSet<DomainSchema> mergedSchemas = new HashSet<DomainSchema>();
        HashSet<DomainSchema> mergedPassthroughPoints = new HashSet<DomainSchema>();
        for (DomainInfo domainInfo : domainInfos) {
            mergedSchemas.addAll(domainInfo.schemas);
            mergedPassthroughPoints.addAll(domainInfo.passthroughPoints);
        }
        result.schemas = new ArrayList<DomainSchema>(mergedSchemas);
        result.passthroughPoints = new ArrayList<DomainSchema>(mergedPassthroughPoints);
        return result;
    }
}

