/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.domain;

import com.envision.eeop.api.domain.MdmObject;
import com.envision.eeop.api.domain.MdmObjectAttributes;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class MdmChildObjects
extends MdmObjectAttributes {
    private static final long serialVersionUID = -905511497091094031L;
    @SerializedName(value="mdmobjects")
    private Map<String, List<MdmObject>> mdmObjectList;

    public MdmChildObjects() {
    }

    public MdmChildObjects(Map<String, List<MdmObject>> mdmObjectList) {
        this.mdmObjectList = mdmObjectList;
    }

    public MdmChildObjects(Map<String, String> attributes, Map<String, List<MdmObject>> mdmObjectList) {
        super(attributes);
        this.mdmObjectList = mdmObjectList;
    }

    public Map<String, List<MdmObject>> getMdmObjectList() {
        return this.mdmObjectList;
    }

    public void setMdmObjectList(Map<String, List<MdmObject>> mdmObjectList) {
        this.mdmObjectList = mdmObjectList;
    }

    public MdmChildObjects merge(MdmChildObjects another) {
        for (Map.Entry<String, List<MdmObject>> anotherEntry : another.getMdmObjectList().entrySet()) {
            String type = anotherEntry.getKey();
            List<MdmObject> mdmObjects = anotherEntry.getValue();
            if (this.mdmObjectList.containsKey(type)) {
                TreeSet<MdmObject> mergeMdmObjects = new TreeSet<MdmObject>((Collection)this.mdmObjectList.get(type));
                mergeMdmObjects.addAll(mdmObjects);
                this.mdmObjectList.put(type, new ArrayList(mergeMdmObjects));
                continue;
            }
            this.mdmObjectList.put(type, mdmObjects);
        }
        return this;
    }

    public String getLastElement() {
        ArrayList<String> maxMdmIDs = new ArrayList<String>();
        for (List<MdmObject> mdmObjects : this.mdmObjectList.values()) {
            if (mdmObjects.isEmpty()) continue;
            maxMdmIDs.add(mdmObjects.get(mdmObjects.size() - 1).getMdmID());
        }
        if (!maxMdmIDs.isEmpty()) {
            return (String)Collections.max(maxMdmIDs);
        }
        return "";
    }

    @Override
    public String toString() {
        return "MdmChildObjects [mdmObjects=" + this.mdmObjectList + ", attributes=" + this.attributes + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mdmObjectList == null ? 0 : this.mdmObjectList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MdmChildObjects other = (MdmChildObjects)obj;
        return !(this.mdmObjectList == null ? other.mdmObjectList != null : !this.mdmObjectList.equals(other.mdmObjectList));
    }
}

