/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.AlarmingListResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.StringUtils;
import com.envision.event.util.FieldFilter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;

public class AlarmingListByDevicesRequest
implements EnvisionRequest<AlarmingListResponse> {
    private static final String API_METHOD = "/eventService/getAlarmings";
    private static final Integer mdmType = 2;
    private String mdmIds;
    private String pageNo;
    private String beginTime;
    private String endTime;
    private FieldFilter fieldFilter;
    private Integer limit;

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    public AlarmingListByDevicesRequest(List<String> mdmIdList) {
        this.mdmIds = StringUtils.listToString(mdmIdList, ',');
    }

    public AlarmingListByDevicesRequest(List<String> mdmIdList, String beginTime) {
        this(mdmIdList);
        this.beginTime = beginTime;
    }

    public AlarmingListByDevicesRequest(List<String> mdmIdList, String beginTime, String endTime) {
        this(mdmIdList, beginTime);
        this.endTime = endTime;
    }

    public AlarmingListByDevicesRequest(List<String> mdmIdList, String beginTime, String endTime, String pageNo) {
        this(mdmIdList, beginTime, endTime);
        this.pageNo = pageNo;
    }

    public AlarmingListByDevicesRequest(List<String> mdmIdList, String beginTime, String endTime, String pageNo, FieldFilter fieldFilter) {
        this(mdmIdList, beginTime, endTime, pageNo);
        this.fieldFilter = fieldFilter;
    }

    public AlarmingListByDevicesRequest(List<String> mdmIdList, String beginTime, String endTime, String pageNo, FieldFilter fieldFilter, Integer limit) {
        this(mdmIdList, beginTime, endTime, pageNo, fieldFilter);
        this.limit = limit;
    }

    public void setMdmIdList(List<String> mdmIdList) {
        this.mdmIds = StringUtils.listToString(mdmIdList, ",");
    }

    public void setPageNo(String pageNo) {
        this.pageNo = pageNo;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilter = fieldFilter;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        txtParams.put("mdmType", (Object)mdmType);
        txtParams.put("pageNo", this.pageNo);
        txtParams.put("mdmIds", this.mdmIds);
        txtParams.put("begin_time", this.beginTime);
        txtParams.put("end_time", this.endTime);
        if (null == this.fieldFilter) {
            txtParams.put("valueFilters", (Object)this.fieldFilter);
        } else {
            txtParams.put("valueFilters", gson.toJson((Object)this.fieldFilter));
        }
        txtParams.put("pageSize", (Object)this.limit);
        return txtParams;
    }

    @Override
    public Class<AlarmingListResponse> getResponseClass() {
        return AlarmingListResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
    }
}

