/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.AlgoMetricsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class AlgoMetricsGetRequest
implements EnvisionRequest<AlgoMetricsGetResponse> {
    private static final String API_METHOD = "/algoService/metrics";
    private String mdmIDList;
    private String metrics;
    private String beginTime;
    private String endTime;
    private String timeGroup;

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    public AlgoMetricsGetRequest(List<String> mdmIds, List<String> metrics, String beginTime, String timeGroup) {
        this.mdmIDList = StringUtils.listToString(mdmIds, ',');
        this.metrics = StringUtils.listToString(metrics, ',');
        this.beginTime = beginTime;
        this.timeGroup = timeGroup;
    }

    public AlgoMetricsGetRequest(List<String> mdmIds, List<String> metrics, String beginTime, String endTime, String timeGroup) {
        this(mdmIds, metrics, beginTime, timeGroup);
        this.endTime = endTime;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        txtParams.put("metrics", this.metrics);
        txtParams.put("begin_time", this.beginTime);
        txtParams.put("end_time", this.endTime);
        txtParams.put("time_group", this.timeGroup);
        return txtParams;
    }

    @Override
    public Class<AlgoMetricsGetResponse> getResponseClass() {
        return AlgoMetricsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
    }
}

