/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.AysnFileDownloadResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public class AsynFileDownloadRequest
implements EnvisionRequest<AysnFileDownloadResponse> {
    private static final String API_METHOD = "/fileService/download/request";
    private static final String DAILY_DATE_FORMAT = "yyyyMMdd";
    private String mdmId;
    private String tableName;
    private String columns;
    private String beginTime;
    private String endTime;
    private String fileName;
    private String callback;
    private String compress;

    public AsynFileDownloadRequest() {
    }

    public AsynFileDownloadRequest(String mdmId, String tableName, String columns, String beginTime, String endTime, String fileName) {
        this.mdmId = mdmId;
        this.tableName = tableName;
        this.columns = columns;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.fileName = fileName;
    }

    public AsynFileDownloadRequest(String mdmId, String tableName, String columns, String beginTime, String endTime, String fileName, String callback, String compress) {
        this.mdmId = mdmId;
        this.tableName = tableName;
        this.columns = columns;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.fileName = fileName;
        this.callback = callback;
        this.compress = compress;
    }

    public String getCompress() {
        return this.compress;
    }

    public void setCompress(String compress) {
        this.compress = "Y".equalsIgnoreCase(compress) ? compress : "N";
    }

    public String getMdmId() {
        return this.mdmId;
    }

    public void setMdmId(String mdmId) {
        this.mdmId = mdmId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName == null || "".equals(fileName.trim()) ? "file" : fileName;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmid", this.mdmId);
        txtParams.put("columns", this.columns);
        txtParams.put("end_time", this.endTime);
        txtParams.put("filename", this.fileName);
        txtParams.put("callback", this.callback);
        txtParams.put("tablename", this.tableName);
        txtParams.put("begin_time", this.beginTime);
        return txtParams;
    }

    @Override
    public Class<AysnFileDownloadResponse> getResponseClass() {
        return AysnFileDownloadResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmId, "mdmid");
        RuleCheckUtils.checkNotEmpty(this.beginTime, "begintime");
        RuleCheckUtils.checkDateFormat(this.beginTime, DAILY_DATE_FORMAT);
        RuleCheckUtils.checkNotEmpty(this.endTime, "endtime");
        RuleCheckUtils.checkDateFormat(this.endTime, DAILY_DATE_FORMAT);
    }
}

