/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.domain.CloudedgeDevice;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.CloudedgeAttachDeviceResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;

public class CloudedgeAttachDeviceRequest
implements EnvisionRequest<CloudedgeAttachDeviceResponse> {
    private static final String API_METHOD = "/cloudedge/device/attach";
    private static final Gson gson = new GsonBuilder().create();
    private final String appId;
    private final List<CloudedgeDevice> devices;
    private final String namespace;
    private final Boolean issubmit;

    public CloudedgeAttachDeviceRequest(String namespace, String appId, List<CloudedgeDevice> devices) {
        this.appId = appId;
        this.devices = devices;
        this.namespace = namespace;
        this.issubmit = true;
    }

    public CloudedgeAttachDeviceRequest(String namespace, String appId, List<CloudedgeDevice> devices, boolean isSubmit) {
        this.appId = appId;
        this.devices = devices;
        this.namespace = namespace;
        this.issubmit = isSubmit;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("appid", this.appId);
        txtParams.put("namespace", this.namespace);
        txtParams.put("devices", gson.toJson(this.devices));
        txtParams.put("issubmit", (Object)this.issubmit);
        return txtParams;
    }

    public static void main(String[] args) {
        boolean is = false;
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("xx", (Object)is);
    }

    @Override
    public Class<CloudedgeAttachDeviceResponse> getResponseClass() {
        return CloudedgeAttachDeviceResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.appId, "appid");
        RuleCheckUtils.checkNotNull(this.devices, "devices");
        RuleCheckUtils.checkNotEmpty(this.namespace, "namespace");
    }
}

