/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.DeviceTemplatesGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.Map;

public class DeviceTemplatesGetRequest
implements EnvisionRequest<DeviceTemplatesGetResponse> {
    private static final String API_METHOD = "/modelService/getDeviceTemplates";
    private String namespace;
    private int categoryID = 0;
    private int typeID = 0;
    private boolean includeGlobal = false;
    private String locale;

    public DeviceTemplatesGetRequest(String namespace) {
        this.namespace = namespace;
    }

    public DeviceTemplatesGetRequest(String namespace, int categoryID) {
        this(namespace);
        this.categoryID = categoryID;
    }

    public DeviceTemplatesGetRequest(String namespace, int categoryID, int typeID) {
        this(namespace, categoryID);
        this.typeID = typeID;
    }

    public DeviceTemplatesGetRequest(String namespace, int categoryID, int typeID, String locale) {
        this(namespace, categoryID, typeID);
        this.locale = locale;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getCategoryID() {
        return this.categoryID;
    }

    public void setCategoryID(int categoryID) {
        this.categoryID = categoryID;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public void setTypeID(int typeID) {
        this.typeID = typeID;
    }

    public boolean isIncludeGlobal() {
        return this.includeGlobal;
    }

    public void setIncludeGlobal(boolean includeGlobal) {
        this.includeGlobal = includeGlobal;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("namespace", this.namespace);
        if (this.categoryID != 0) {
            txtParams.put("category", String.valueOf(this.categoryID));
        }
        if (this.typeID != 0) {
            txtParams.put("type", String.valueOf(this.typeID));
        }
        if (this.includeGlobal) {
            txtParams.put("includeGlobal", "true");
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        return txtParams;
    }

    @Override
    public Class<DeviceTemplatesGetResponse> getResponseClass() {
        return DeviceTemplatesGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotNull(this.namespace, "namespace is mandatory");
        RuleCheckUtils.checkArgument(this.typeID == 0 || this.categoryID != 0, "category is missing while type is provided");
    }
}

