/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionPaginationRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.DimensionsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.google.gson.GsonBuilder;
import java.util.Map;

public class DimensionFindByColumnsRequest
extends EnvisionPaginationRequest<DimensionsGetResponse> {
    private static final String API_METHOD = "/dimension/findByColumns";
    private String mdmid;
    private String table;
    private String columnFilters;

    public DimensionFindByColumnsRequest(String mdmid, String table, Map<String, Object> columns) {
        this.mdmid = mdmid;
        this.table = table;
        this.columnFilters = new GsonBuilder().serializeNulls().create().toJson(columns);
    }

    public DimensionFindByColumnsRequest(String mdmid, String table, Map<String, Object> columns, int pageNo, int pageSize) {
        this(mdmid, table, columns);
        this.setPageNo(pageNo);
        this.setPageSize(pageSize);
    }

    public String getMdmid() {
        return this.mdmid;
    }

    public void setMdmid(String mdmid) {
        this.mdmid = mdmid;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumnFilters() {
        return this.columnFilters;
    }

    public void setColumnFilters(String columnFilters) {
        this.columnFilters = columnFilters;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmid", this.mdmid);
        txtParams.put("table", this.table);
        txtParams.put("columnFilters", this.columnFilters);
        txtParams.putAll(this.getPaginationParams());
        return txtParams;
    }

    @Override
    public Class<DimensionsGetResponse> getResponseClass() {
        return DimensionsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        super.check();
        RuleCheckUtils.checkNotEmpty(this.mdmid, "mdmid");
        RuleCheckUtils.checkNotEmpty(this.table, "table");
        RuleCheckUtils.checkNotEmpty(this.columnFilters, "columnFilters");
    }
}

