/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.DimensionsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class DimensionFindByKeysRequest
implements EnvisionRequest<DimensionsGetResponse> {
    private static final String API_METHOD = "/dimension/findByKeys";
    private String mdmid;
    private String table;
    private String keys;

    public DimensionFindByKeysRequest(String mdmid, String table, List<String> keys) {
        this.mdmid = mdmid;
        this.table = table;
        this.keys = StringUtils.listToString(keys, ',');
    }

    public String getMdmid() {
        return this.mdmid;
    }

    public void setMdmid(String mdmid) {
        this.mdmid = mdmid;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getKeys() {
        return this.keys;
    }

    public void setKeys(String keys) {
        this.keys = keys;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmid", this.mdmid);
        txtParams.put("table", this.table);
        txtParams.put("keys", this.keys);
        return txtParams;
    }

    @Override
    public Class<DimensionsGetResponse> getResponseClass() {
        return DimensionsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmid, "mdmid");
        RuleCheckUtils.checkNotEmpty(this.table, "table");
        RuleCheckUtils.checkNotEmpty(this.keys, "keys");
    }
}

