/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;

public class DomainControlRequest
implements EnvisionRequest<EnvisionResponse> {
    private static final String API_METHOD = "/controlService/control";
    private String mdmid;
    private Map<String, String> pointsJson;

    public DomainControlRequest(String mdmid, Map<String, String> pointsJson) {
        this.mdmid = mdmid;
        this.pointsJson = pointsJson;
    }

    public DomainControlRequest(String mdmid, String point) {
        this.mdmid = mdmid;
        this.pointsJson = new HashMap<String, String>();
        this.pointsJson.put(point, "");
    }

    public DomainControlRequest(String mdmid, String point, String parameter) {
        this.mdmid = mdmid;
        this.pointsJson = new HashMap<String, String>();
        this.pointsJson.put(point, parameter);
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmid", this.mdmid);
        txtParams.put("points", new Gson().toJson(this.pointsJson, new TypeToken<Map<String, String>>(){}.getType()));
        Map.Entry<String, String> firstPoint = this.pointsJson.entrySet().iterator().next();
        txtParams.put("point", firstPoint.getKey());
        if (!StringUtils.isEmpty(firstPoint.getValue())) {
            txtParams.put("parameter", firstPoint.getValue());
        }
        return txtParams;
    }

    @Override
    public Class<EnvisionResponse> getResponseClass() {
        return EnvisionResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmid, "mdmid");
        RuleCheckUtils.checkNotEmpty(this.pointsJson, "points");
    }
}

