/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.DomainMetricsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class DomainMetricGetRequest
implements EnvisionRequest<DomainMetricsGetResponse> {
    private static final String API_METHOD = "/metricService/singleMetric";
    private String mdmIDList;
    private String metric;
    private String beginTime;
    private String endTime;
    private String timeGroup;
    private String sortType;

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    public DomainMetricGetRequest(List<String> mdmIds, String metric, String beginTime, String timeGroup) {
        this.mdmIDList = StringUtils.listToString(mdmIds, ',');
        this.metric = metric;
        this.beginTime = beginTime;
        this.timeGroup = timeGroup;
    }

    public DomainMetricGetRequest(List<String> mdmIds, String metric, String beginTime, String endTime, String timeGroup) {
        this(mdmIds, metric, beginTime, timeGroup);
        this.endTime = endTime;
    }

    public DomainMetricGetRequest(List<String> mdmIds, String metric, String beginTime, String endTime, String timeGroup, String sortType) {
        this(mdmIds, metric, beginTime, timeGroup);
        this.endTime = endTime;
        this.sortType = sortType;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        txtParams.put("metric", this.metric);
        txtParams.put("begin_time", this.beginTime);
        txtParams.put("end_time", this.endTime);
        txtParams.put("time_group", this.timeGroup);
        txtParams.put("sort_type", this.sortType);
        return txtParams;
    }

    @Override
    public Class<DomainMetricsGetResponse> getResponseClass() {
        return DomainMetricsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
    }
}

