/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.DomainSchemasGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DomainSchemasGetRequest
implements EnvisionRequest<DomainSchemasGetResponse> {
    private static final String API_METHOD = "/mdmService/getSchemas";
    public static final String FIELD_DESC = "desc";
    public static final String FIELD_METADATA = "metadata";
    private String mdmIDList;
    private String fieldList;
    private String locale;

    public DomainSchemasGetRequest(List<String> mdmIDList, boolean includeDesc, boolean includeMetadata) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        ArrayList<String> fields = new ArrayList<String>();
        if (includeDesc) {
            fields.add(FIELD_DESC);
        }
        if (includeMetadata) {
            fields.add(FIELD_METADATA);
        }
        if (!fields.isEmpty()) {
            this.fieldList = StringUtils.listToString(fields, ',');
        }
    }

    public DomainSchemasGetRequest(List<String> mdmIDList, boolean includeDesc, boolean includeMetadata, String locale) {
        this(mdmIDList, includeDesc, includeMetadata);
        this.locale = locale;
    }

    public DomainSchemasGetRequest(List<String> mdmIDList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
    }

    public DomainSchemasGetRequest(List<String> mdmIDList, List<String> fieldList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.fieldList = StringUtils.listToString(fieldList, ',');
    }

    public String getMdmIDList() {
        return this.mdmIDList;
    }

    public void setMdmIDList(String mdmIDList) {
        this.mdmIDList = mdmIDList;
    }

    public String getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(String fieldList) {
        this.fieldList = fieldList;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        if (!StringUtils.isEmpty(this.fieldList)) {
            txtParams.put("fields", this.fieldList);
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        return txtParams;
    }

    @Override
    public Class<DomainSchemasGetResponse> getResponseClass() {
        return DomainSchemasGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmIDList, "mdmids");
    }
}

