/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.EventConfirmGetResponse;
import com.envision.eeop.api.util.EventJsonParser;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eos.event.api.bo.LanguageType;
import com.envision.eos.event.api.expression.Filter;
import java.util.HashMap;
import java.util.Map;

public class EventConfirmRequest
implements EnvisionRequest<EventConfirmGetResponse> {
    private static final String API_METHOD = "/eventService/confirm";
    private Filter filter;
    private String confirmPerson;
    private int value;
    private LanguageType language;

    public EventConfirmRequest(Filter filter, String confirmPerson) {
        this(filter, LanguageType.ZH_CN, confirmPerson, 1);
    }

    public EventConfirmRequest(Filter filter, String confirmPerson, int value) {
        this(filter, LanguageType.ZH_CN, confirmPerson, value);
    }

    public EventConfirmRequest(Filter filter, LanguageType language, String confirmPerson, int value) {
        this.filter = filter;
        this.confirmPerson = confirmPerson;
        this.value = value;
        this.language = language;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filter", EventJsonParser.toJson(this.filter));
        params.put("confirmPerson", this.confirmPerson);
        params.put("value", String.valueOf(this.value));
        params.put("language", this.language.toString());
        return params;
    }

    @Override
    public Class<EventConfirmGetResponse> getResponseClass() {
        return EventConfirmGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotNull(this.filter, "filter");
        RuleCheckUtils.checkNotEmpty(this.confirmPerson, "confirmPerson");
    }
}

