/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.EventUpdateResponse;
import com.envision.eeop.api.util.EventJsonParser;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eos.event.api.bo.EventUpdate;
import com.envision.eos.event.api.expression.Column;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventUpdateRequest
implements EnvisionRequest<EventUpdateResponse> {
    private static final String API_METHOD = "/eventService/update";
    public static final Type typeOfEventUpdateList = new TypeToken<List<EventUpdate>>(){}.getType();
    private List<EventUpdate> events;

    public EventUpdateRequest(List<EventUpdate> events) {
        this.events = events;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("events", EventJsonParser.toJson(this.events, typeOfEventUpdateList));
        return params;
    }

    @Override
    public Class<EventUpdateResponse> getResponseClass() {
        return EventUpdateResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotNull(this.events, "events");
    }

    public static void main(String[] args) {
        HashMap<Column, String> fs = new HashMap<Column, String>();
        fs.put(Column.TAG, "xu");
        EventUpdate event = new EventUpdate("64b1bf748a0e4d038960cb0e94611f55", fs);
        ArrayList<EventUpdate> events = new ArrayList<EventUpdate>();
        events.add(event);
        System.out.println(EventJsonParser.toJson(events, typeOfEventUpdateList));
        String ori = EventJsonParser.toJson(events, typeOfEventUpdateList);
        System.out.println(EventJsonParser.toJson(EventJsonParser.fromJson(ori, typeOfEventUpdateList)));
    }
}

