/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.request.AbstractEnvisionStreamRequest;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FileUploadRequest
extends AbstractEnvisionStreamRequest {
    private static final String API_METHOD = "/fileService/upload";
    private String mdmId;
    private String timestamp;

    public String getMdmId() {
        return this.mdmId;
    }

    public void setMdmId(String mdmId) {
        this.mdmId = mdmId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public FileUploadRequest(String mdmId, String timestamp, File file) {
        this.mdmId = mdmId;
        this.timestamp = timestamp;
        this.file = file;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        HashMap<String, String> txtParams = new HashMap<String, String>();
        txtParams.put("mdmid", this.mdmId);
        txtParams.put("timestamp", this.timestamp);
        return txtParams;
    }

    public Map<String, File> getFileParams() {
        HashMap<String, File> map = new HashMap<String, File>();
        map.put("data", this.file);
        return map;
    }

    public Class<EnvisionResponse> getResponseClass() {
        return EnvisionResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmId, "mdmid");
        RuleCheckUtils.checkNotEmpty(this.timestamp, "timestamp");
        RuleCheckUtils.checkDateFormat(this.timestamp, "yyyyMMdd");
    }
}

