/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.FleetMetricsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class FleetMetricsGetRequest
implements EnvisionRequest<FleetMetricsGetResponse> {
    private static final String API_METHOD = "/metricService/fleetMetrics";
    private String mdmIDList;
    private String metricList;
    private String beginTime;
    private String endTime;
    private String timeGroup;

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    public FleetMetricsGetRequest(List<String> mdmIds, List<String> metrics, String beginTime, String timeGroup) {
        this.mdmIDList = StringUtils.listToString(mdmIds, ',');
        this.metricList = StringUtils.listToString(metrics, ',');
        this.beginTime = beginTime;
        this.timeGroup = timeGroup;
    }

    public FleetMetricsGetRequest(List<String> mdmIds, List<String> metrics, String beginTime, String endTime, String timeGroup) {
        this(mdmIds, metrics, beginTime, timeGroup);
        this.endTime = endTime;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        txtParams.put("metrics", this.metricList);
        txtParams.put("begin_time", this.beginTime);
        txtParams.put("end_time", this.endTime);
        txtParams.put("time_group", this.timeGroup);
        return txtParams;
    }

    @Override
    public Class<FleetMetricsGetResponse> getResponseClass() {
        return FleetMetricsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
    }
}

