/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public class LicensedClientRegisterRequest
implements EnvisionRequest<EnvisionResponse> {
    private static final String API_METHOD = "/mdmService/registerLicensedClient";
    private String licenseFingerprint;
    private String clientSN;
    private String siteID;
    private String desc;

    public LicensedClientRegisterRequest(String licenseFingerprint, String clientSN, String siteID) {
        this.licenseFingerprint = licenseFingerprint;
        this.clientSN = clientSN;
        this.siteID = siteID;
    }

    public LicensedClientRegisterRequest(String licenseFingerprint, String clientSN, String siteID, String desc) {
        this(licenseFingerprint, clientSN, siteID);
        this.desc = desc;
    }

    public String getLicenseFingerprint() {
        return this.licenseFingerprint;
    }

    public void setLicenseFingerprint(String licenseFingerprint) {
        this.licenseFingerprint = licenseFingerprint;
    }

    public String getClientSN() {
        return this.clientSN;
    }

    public void setClientSN(String clientSN) {
        this.clientSN = clientSN;
    }

    public String getSiteID() {
        return this.siteID;
    }

    public void setSiteID(String siteID) {
        this.siteID = siteID;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("licFp", this.licenseFingerprint);
        txtParams.put("clientSn", this.clientSN);
        txtParams.put("siteid", this.siteID);
        txtParams.put("desc", this.desc);
        return txtParams;
    }

    @Override
    public Class<EnvisionResponse> getResponseClass() {
        return EnvisionResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.licenseFingerprint, "licFp");
        RuleCheckUtils.checkNotEmpty(this.clientSN, "clientSn");
    }
}

