/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public class LicensedClientUnregisterRequest
implements EnvisionRequest<EnvisionResponse> {
    private static final String API_METHOD = "/mdmService/unregisterLicensedClient";
    private String licenseFingerprint;
    private String clientSN;

    public LicensedClientUnregisterRequest(String licenseFingerprint, String clientSN) {
        this.licenseFingerprint = licenseFingerprint;
        this.clientSN = clientSN;
    }

    public String getLicenseFingerprint() {
        return this.licenseFingerprint;
    }

    public void setLicenseFingerprint(String licenseFingerprint) {
        this.licenseFingerprint = licenseFingerprint;
    }

    public String getClientSN() {
        return this.clientSN;
    }

    public void setClientSN(String clientSN) {
        this.clientSN = clientSN;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("licFp", this.licenseFingerprint);
        txtParams.put("clientSn", this.clientSN);
        return txtParams;
    }

    @Override
    public Class<EnvisionResponse> getResponseClass() {
        return EnvisionResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.licenseFingerprint, "licFp");
        RuleCheckUtils.checkNotEmpty(this.clientSN, "clientSn");
    }
}

