/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.LicensedClientsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class LicensedClientsGetRequest
implements EnvisionRequest<LicensedClientsGetResponse> {
    private static final String API_METHOD = "/mdmService/getLicensedClients";
    private String licenseFingerprint;
    private String clientSnList;
    private String attributeList;
    private String locale;

    public LicensedClientsGetRequest(String licenseFingerprint, List<String> clientSnList) {
        this.licenseFingerprint = licenseFingerprint;
        this.clientSnList = StringUtils.listToString(clientSnList, ',');
    }

    public LicensedClientsGetRequest(String licenseFingerprint, List<String> clientSnList, String locale) {
        this(licenseFingerprint, clientSnList);
        this.locale = locale;
    }

    public LicensedClientsGetRequest(String licenseFingerprint, List<String> clientSnList, List<String> attributeList, String locale) {
        this(licenseFingerprint, clientSnList, locale);
        this.attributeList = StringUtils.listToString(attributeList, ',');
    }

    public String getLicenseFingerprint() {
        return this.licenseFingerprint;
    }

    public void setLicenseFingerprint(String licenseFingerprint) {
        this.licenseFingerprint = licenseFingerprint;
    }

    public String getClientSnList() {
        return this.clientSnList;
    }

    public void setClientSnList(String clientSnList) {
        this.clientSnList = clientSnList;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("licFp", this.licenseFingerprint);
        txtParams.put("clientSns", this.clientSnList);
        if (!StringUtils.isEmpty(this.attributeList)) {
            txtParams.put("attributes", this.attributeList);
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        return txtParams;
    }

    @Override
    public Class<LicensedClientsGetResponse> getResponseClass() {
        return LicensedClientsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.licenseFingerprint, "licFp");
        RuleCheckUtils.checkNotEmpty(this.clientSnList, "clientSns");
    }
}

