/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public class LicensedObjectRegisterRequest
implements EnvisionRequest<EnvisionResponse> {
    private static final String API_METHOD = "/mdmService/registerLicensedObject";
    private String licenseFingerprint;
    private String uid;
    private String mdmID;

    public LicensedObjectRegisterRequest(String licenseFingerprint, String uid, String mdmID) {
        this.licenseFingerprint = licenseFingerprint;
        this.uid = uid;
        this.mdmID = mdmID;
    }

    public String getLicenseFingerprint() {
        return this.licenseFingerprint;
    }

    public void setLicenseFingerprint(String licenseFingerprint) {
        this.licenseFingerprint = licenseFingerprint;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getMdmID() {
        return this.mdmID;
    }

    public void setMdmID(String mdmID) {
        this.mdmID = mdmID;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("licFp", this.licenseFingerprint);
        txtParams.put("uid", this.uid);
        txtParams.put("mdmid", this.mdmID);
        return txtParams;
    }

    @Override
    public Class<EnvisionResponse> getResponseClass() {
        return EnvisionResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.licenseFingerprint, "licFp");
        RuleCheckUtils.checkNotEmpty(this.uid, "uid");
    }
}

