/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.LicensedObjectsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class LicensedObjectsGetRequest
implements EnvisionRequest<LicensedObjectsGetResponse> {
    private static final String API_METHOD = "/mdmService/getLicensedObjects";
    private String licenseFingerprint;
    private String uidList;
    private String attributeList;
    private String locale;

    public LicensedObjectsGetRequest(String licenseFingerprint, List<String> uidList) {
        this.licenseFingerprint = licenseFingerprint;
        this.setUidList(StringUtils.listToString(uidList, ','));
    }

    public LicensedObjectsGetRequest(String licenseFingerprint, List<String> uidList, String locale) {
        this(licenseFingerprint, uidList);
        this.locale = locale;
    }

    public LicensedObjectsGetRequest(String licenseFingerprint, List<String> uidList, List<String> attributeList, String locale) {
        this(licenseFingerprint, uidList, locale);
        this.attributeList = StringUtils.listToString(attributeList, ',');
    }

    public String getLicenseFingerprint() {
        return this.licenseFingerprint;
    }

    public void setLicenseFingerprint(String licenseFingerprint) {
        this.licenseFingerprint = licenseFingerprint;
    }

    public String getUidList() {
        return this.uidList;
    }

    public void setUidList(String uidList) {
        this.uidList = uidList;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("licFp", this.licenseFingerprint);
        txtParams.put("uids", this.uidList);
        if (!StringUtils.isEmpty(this.attributeList)) {
            txtParams.put("attributes", this.attributeList);
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        return txtParams;
    }

    @Override
    public Class<LicensedObjectsGetResponse> getResponseClass() {
        return LicensedObjectsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.licenseFingerprint, "licFp");
        RuleCheckUtils.checkNotEmpty(this.uidList, "uids");
    }
}

