/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.MdmDimensionDataGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;

public class MdmDimensionDataGetRequest
implements EnvisionRequest<MdmDimensionDataGetResponse> {
    private static final String API_METHOD = "/mdmService/getDimensionData";
    private String type;
    private String filterList;

    public MdmDimensionDataGetRequest(String type) {
        this.type = type;
        this.filterList = "";
    }

    public MdmDimensionDataGetRequest(String type, Map<String, String> filterSpecs) {
        this.type = type;
        ArrayList<String> filters = new ArrayList<String>();
        for (String filter : filterSpecs.keySet()) {
            filters.add(filter + ":\"" + filterSpecs.get(filter));
        }
        if (!filters.isEmpty()) {
            this.filterList = StringUtils.listToString(filters, "\",");
            this.filterList = this.filterList.concat("\"");
        } else {
            this.filterList = "";
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("type", this.type);
        txtParams.put("filters", this.filterList);
        return txtParams;
    }

    @Override
    public Class<MdmDimensionDataGetResponse> getResponseClass() {
        return MdmDimensionDataGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.type, "type");
    }
}

