/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.MdmDomainPointsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class MdmDomainPointsGetRequest
implements EnvisionRequest<MdmDomainPointsGetResponse> {
    private static final String API_METHOD = "/domainService/getmdmidspoints";
    private String mdmIDList;
    private String pointIDList;
    private String fieldList;
    private Integer timeWindow;

    public MdmDomainPointsGetRequest(List<String> mdmIDList, List<String> pointIDList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.pointIDList = StringUtils.listToString(pointIDList, ',');
    }

    public MdmDomainPointsGetRequest(List<String> mdmIDList, List<String> pointIDList, List<String> fieldList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.pointIDList = StringUtils.listToString(pointIDList, ',');
        this.fieldList = StringUtils.listToString(fieldList, ',');
    }

    public MdmDomainPointsGetRequest(List<String> mdmIDList, List<String> pointIDList, Integer timeWindow) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.pointIDList = StringUtils.listToString(pointIDList, ',');
        this.timeWindow = timeWindow;
    }

    public MdmDomainPointsGetRequest(List<String> mdmIDList, List<String> pointIDList, List<String> fieldList, Integer timeWindow) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.pointIDList = StringUtils.listToString(pointIDList, ',');
        this.fieldList = StringUtils.listToString(fieldList, ',');
        this.timeWindow = timeWindow;
    }

    public String getMdmIDList() {
        return this.mdmIDList;
    }

    public void setMdmIDList(String mdmIDList) {
        this.mdmIDList = mdmIDList;
    }

    public String getPointIDLists() {
        return this.pointIDList;
    }

    public void setPointIDLists(String pointIDLists) {
        this.pointIDList = pointIDLists;
    }

    public String getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(String fieldList) {
        this.fieldList = fieldList;
    }

    public Integer getTimeWindow() {
        return this.timeWindow;
    }

    public void setTimeWindow(Integer timeWindow) {
        this.timeWindow = timeWindow;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        txtParams.put("points", this.pointIDList);
        if (!StringUtils.isEmpty(this.fieldList)) {
            txtParams.put("fields", this.fieldList);
        }
        if (this.timeWindow != null) {
            txtParams.put("timeWindow", (Object)this.timeWindow);
        }
        return txtParams;
    }

    @Override
    public Class<MdmDomainPointsGetResponse> getResponseClass() {
        return MdmDomainPointsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmIDList, "mdmids");
        RuleCheckUtils.checkNotEmpty(this.pointIDList, "points");
    }
}

