/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionSkipAndLimitRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.request.AppointedFilter;
import com.envision.eeop.api.request.Filter;
import com.envision.eeop.api.response.MdmObjectStructureGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.JsonParser;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MdmFilteredObjectsGetRequest
extends EnvisionSkipAndLimitRequest<MdmObjectStructureGetResponse> {
    private static final String API_METHOD = "/mdmService/getFilteredObjects";
    private String token;
    private String type;
    private String filterList;
    private String appointedFilterList;
    private String attributeList;
    private boolean queryOrgUnit = false;
    private String locale;

    public MdmFilteredObjectsGetRequest(String token, String type) {
        this.token = token;
        this.type = type;
        this.filterList = JsonParser.toJson(new ArrayList());
        this.appointedFilterList = JsonParser.toJson(new ArrayList());
        this.attributeList = "";
    }

    public MdmFilteredObjectsGetRequest(String token, String type, boolean queryOrgUnit) {
        this(token, type);
        this.queryOrgUnit = queryOrgUnit;
    }

    public MdmFilteredObjectsGetRequest(String token, String type, String locale) {
        this(token, type);
        this.locale = locale;
    }

    public MdmFilteredObjectsGetRequest(String token, String type, boolean queryOrgUnit, String locale) {
        this(token, type, locale);
        this.queryOrgUnit = queryOrgUnit;
    }

    public MdmFilteredObjectsGetRequest(String token, String type, List<Filter> filterList, List<AppointedFilter> appointedFilterList, List<String> attributeList) {
        this.token = token;
        this.type = type;
        this.filterList = JsonParser.toJson(filterList);
        this.appointedFilterList = JsonParser.toJson(appointedFilterList);
        this.attributeList = StringUtils.listToString(attributeList, ',');
    }

    public MdmFilteredObjectsGetRequest(String token, String type, List<Filter> filterList, List<AppointedFilter> appointedFilterList, List<String> attributeList, boolean queryOrgUnit) {
        this(token, type, filterList, appointedFilterList, attributeList);
        this.queryOrgUnit = queryOrgUnit;
    }

    public MdmFilteredObjectsGetRequest(String token, String type, List<Filter> filterList, List<AppointedFilter> appointedFilterList, List<String> attributeList, String locale) {
        this(token, type, filterList, appointedFilterList, attributeList);
        this.locale = locale;
    }

    public MdmFilteredObjectsGetRequest(String token, String type, List<Filter> filterList, List<AppointedFilter> appointedFilterList, List<String> attributeList, boolean queryOrgUnit, String locale) {
        this(token, type, filterList, appointedFilterList, attributeList, locale);
        this.queryOrgUnit = queryOrgUnit;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFilterList() {
        return this.filterList;
    }

    public void setFilterList(String filterList) {
        this.filterList = filterList;
    }

    public String getAppointedFilterList() {
        return this.appointedFilterList;
    }

    public void setAppointedFilterList(String appointedFilterList) {
        this.appointedFilterList = appointedFilterList;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    public boolean isQueryOrgUnit() {
        return this.queryOrgUnit;
    }

    public void setQueryOrgUnit(boolean queryOrgUnit) {
        this.queryOrgUnit = queryOrgUnit;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("token", this.token);
        txtParams.put("type", this.type);
        txtParams.put("filter", this.filterList);
        txtParams.put("appointedFilter", this.appointedFilterList);
        txtParams.put("attributes", this.attributeList);
        if (this.queryOrgUnit) {
            txtParams.put("queryOrgUnit", String.valueOf(true));
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        txtParams.putAll(this.getPaginationParams());
        return txtParams;
    }

    @Override
    public Class<MdmObjectStructureGetResponse> getResponseClass() {
        return MdmObjectStructureGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        super.check();
        RuleCheckUtils.checkNotEmpty(this.token, "token");
        RuleCheckUtils.checkNotEmpty(this.type, "type");
        RuleCheckUtils.checkFilterFormat(this.filterList, "filter");
    }
}

