/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionSkipAndLimitRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.MdmObjectAttributesGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class MdmObjectAttributesGetRequest
extends EnvisionSkipAndLimitRequest<MdmObjectAttributesGetResponse> {
    private static final String API_METHOD = "/mdmService/getObjectAttributes";
    private String mdmIDList;
    private String attributeList;
    private String locale;

    public MdmObjectAttributesGetRequest(List<String> mdmIDList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
    }

    public MdmObjectAttributesGetRequest(List<String> mdmIDList, String locale) {
        this(mdmIDList);
        this.locale = locale;
    }

    public MdmObjectAttributesGetRequest(List<String> mdmIDList, List<String> attributeList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.attributeList = StringUtils.listToString(attributeList, ',');
    }

    public MdmObjectAttributesGetRequest(List<String> mdmIDList, List<String> attributeList, String locale) {
        this(mdmIDList, attributeList);
        this.locale = locale;
    }

    public String getMdmIDList() {
        return this.mdmIDList;
    }

    public void setMdmIDList(String mdmIDList) {
        this.mdmIDList = mdmIDList;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        if (!StringUtils.isEmpty(this.attributeList)) {
            txtParams.put("attributes", this.attributeList);
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        txtParams.putAll(this.getPaginationParams());
        return txtParams;
    }

    @Override
    public Class<MdmObjectAttributesGetResponse> getResponseClass() {
        return MdmObjectAttributesGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        super.check();
        RuleCheckUtils.checkNotEmpty(this.mdmIDList, "mdmids");
    }
}

