/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MdmObjectAttributesSetRequest
implements EnvisionRequest<EnvisionResponse> {
    private static final String API_METHOD = "/mdmService/setObjectAttributes";
    private String mdmID;
    @Deprecated
    private String attributeList;
    private Map<String, String> attributeJson = new HashMap<String, String>();
    private String locale;
    private String defaultLocale;

    public MdmObjectAttributesSetRequest(String mdmID, Map<String, String> attributeValues) {
        this.mdmID = mdmID;
        this.attributeJson.putAll(attributeValues);
    }

    public MdmObjectAttributesSetRequest(String mdmID, Map<String, String> attributeValues, String locale, boolean defaultLocale) {
        this(mdmID, attributeValues);
        this.locale = locale;
        this.defaultLocale = String.valueOf(defaultLocale);
    }

    public String getMdmID() {
        return this.mdmID;
    }

    public void setMdmID(String mdmID) {
        this.mdmID = mdmID;
    }

    public Map<String, String> getAttributeJson() {
        return this.attributeJson;
    }

    public void setAttributeJson(Map<String, String> attributeJson) {
        this.attributeJson = attributeJson;
    }

    public String getAttributeList() {
        StringBuffer sb = new StringBuffer();
        Iterator<Map.Entry<String, String>> it = this.attributeJson.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sb.append(entry.getKey()).append(":\"").append(entry.getValue()).append(it.hasNext() ? "\"," : "\"");
        }
        return sb.toString();
    }

    public void setAttributeList(String attributeList) {
        String[] attributeValues;
        for (String attributeValue : attributeValues = StringUtils.split(attributeList.substring(0, attributeList.length() - 1), "\",")) {
            String[] keyValue = StringUtils.split(attributeValue, ":\"");
            this.attributeJson.put(keyValue[0], keyValue[1]);
        }
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmid", this.mdmID);
        txtParams.put("attributeValues", new Gson().toJson(this.attributeJson, new TypeToken<Map<String, String>>(){}.getType()));
        txtParams.put("attributes", this.getAttributeList());
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        if (!StringUtils.isEmpty(this.defaultLocale)) {
            txtParams.put("defaultLocale", this.defaultLocale);
        }
        return txtParams;
    }

    @Override
    public Class<EnvisionResponse> getResponseClass() {
        return EnvisionResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.mdmID, "mdmid");
        RuleCheckUtils.checkNotEmpty(this.attributeJson, "attributeValues");
    }
}

