/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.MdmObjectInsertResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.JsonParser;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.util.Map;

public class MdmObjectInsertRequest
implements EnvisionRequest<MdmObjectInsertResponse> {
    private static final String API_METHOD = "/mdmService/insertObject";
    private String parentID;
    private String category;
    private String type;
    private String attributes;
    private String mdmID;
    private String locale;

    public MdmObjectInsertRequest(String parentID, int typeID, Map<String, String> attributes) {
        this.parentID = parentID;
        this.type = String.valueOf(typeID);
        this.attributes = JsonParser.toJson(attributes);
    }

    public MdmObjectInsertRequest(String parentID, int categoryID, int typeID, Map<String, String> attributes) {
        this(parentID, typeID, attributes);
        this.category = String.valueOf(categoryID);
    }

    public MdmObjectInsertRequest(String parentID, int typeID, Map<String, String> attributes, String mdmID) {
        this(parentID, typeID, attributes);
        this.mdmID = mdmID;
    }

    public MdmObjectInsertRequest(String parentID, int category, int typeID, Map<String, String> attributes, String mdmID) {
        this(parentID, category, typeID, attributes);
        this.mdmID = mdmID;
    }

    public MdmObjectInsertRequest(String parentID, int typeID, Map<String, String> attributes, String mdmID, String locale) {
        this(parentID, typeID, attributes, mdmID);
        this.locale = locale;
    }

    public MdmObjectInsertRequest(String parentID, int category, int typeID, Map<String, String> attributes, String mdmID, String locale) {
        this(parentID, category, typeID, attributes, mdmID);
        this.locale = locale;
    }

    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public int getCategory() {
        return Integer.parseInt(this.category);
    }

    public void setCategory(int category) {
        this.category = String.valueOf(category);
    }

    public int getType() {
        return Integer.parseInt(this.type);
    }

    public void setType(int type) {
        this.type = String.valueOf(type);
    }

    public Map<String, String> getAttributes() {
        return (Map)JsonParser.fromJson(this.attributes, new TypeToken<Map<String, String>>(){}.getType());
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = JsonParser.toJson(attributes);
    }

    public String getMdmID() {
        return this.mdmID;
    }

    public void setMdmID(String mdmID) {
        this.mdmID = mdmID;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("parentid", this.parentID);
        if (!StringUtils.isEmpty(this.category)) {
            txtParams.put("category", this.category);
        }
        txtParams.put("type", this.type);
        if (!StringUtils.isEmpty(this.attributes)) {
            txtParams.put("attributes", this.attributes);
        }
        if (!StringUtils.isEmpty(this.mdmID)) {
            txtParams.put("mdmid", this.mdmID);
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        return txtParams;
    }

    @Override
    public Class<MdmObjectInsertResponse> getResponseClass() {
        return MdmObjectInsertResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.parentID, "parentid");
        RuleCheckUtils.checkNotEmpty(this.type, "type");
        if (Integer.parseInt(this.type) >= 102) {
            RuleCheckUtils.checkNotEmpty(this.category, "category");
        }
    }
}

