/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionSkipAndLimitRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.MdmObjectStructureGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class MdmObjectStructureGetRequest
extends EnvisionSkipAndLimitRequest<MdmObjectStructureGetResponse> {
    private static final String API_METHOD = "/mdmService/getObjectStructure";
    private String token;
    private String type;
    private String attributeList;
    private String locale;

    public MdmObjectStructureGetRequest(String token, String type) {
        this.token = token;
        this.type = type;
        this.attributeList = "";
    }

    public MdmObjectStructureGetRequest(String token, String type, String locale) {
        this(token, type);
        this.locale = locale;
    }

    public MdmObjectStructureGetRequest(String token, String type, List<String> attributeList) {
        this(token, type);
        this.attributeList = StringUtils.listToString(attributeList, ',');
    }

    public MdmObjectStructureGetRequest(String token, String type, List<String> attributeList, String locale) {
        this(token, type, attributeList);
        this.locale = locale;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("token", this.token);
        txtParams.put("type", this.type);
        txtParams.put("attributes", this.attributeList);
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        txtParams.putAll(this.getPaginationParams());
        return txtParams;
    }

    @Override
    public Class<MdmObjectStructureGetResponse> getResponseClass() {
        return MdmObjectStructureGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        super.check();
        RuleCheckUtils.checkNotEmpty(this.token, "token");
        RuleCheckUtils.checkNotEmpty(this.type, "type");
    }
}

