/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionSkipAndLimitRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.MdmObjectsGetResponse;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import com.envision.eeop.api.util.StringUtils;
import java.util.List;
import java.util.Map;

public class MdmObjectsGetRequest
extends EnvisionSkipAndLimitRequest<MdmObjectsGetResponse> {
    private static final String API_METHOD = "/mdmService/getObjects";
    private String mdmIDList;
    private String typeList;
    private String attributeList;
    private String locale;

    public MdmObjectsGetRequest(List<String> mdmIDList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
    }

    public MdmObjectsGetRequest(List<String> mdmIDList, String locale) {
        this(mdmIDList);
        this.locale = locale;
    }

    public MdmObjectsGetRequest(List<String> mdmIDList, List<String> typeList, List<String> attributeList) {
        this.mdmIDList = StringUtils.listToString(mdmIDList, ',');
        this.typeList = StringUtils.listToString(typeList, ',');
        this.attributeList = StringUtils.listToString(attributeList, ',');
    }

    public MdmObjectsGetRequest(List<String> mdmIDList, List<String> typeList, List<String> attributeList, String locale) {
        this(mdmIDList, typeList, attributeList);
        this.locale = locale;
    }

    public String getMdmIDList() {
        return this.mdmIDList;
    }

    public void setMdmIDList(String mdmIDList) {
        this.mdmIDList = mdmIDList;
    }

    public String getTypeList() {
        return this.typeList;
    }

    public void setTypeList(String typeList) {
        this.typeList = typeList;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("mdmids", this.mdmIDList);
        if (!StringUtils.isEmpty(this.typeList)) {
            txtParams.put("types", this.typeList);
        }
        if (!StringUtils.isEmpty(this.attributeList)) {
            txtParams.put("attributes", this.attributeList);
        }
        if (!StringUtils.isEmpty(this.locale)) {
            txtParams.put("locale", this.locale);
        }
        txtParams.putAll(this.getPaginationParams());
        return txtParams;
    }

    @Override
    public Class<MdmObjectsGetResponse> getResponseClass() {
        return MdmObjectsGetResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        super.check();
        RuleCheckUtils.checkNotEmpty(this.mdmIDList, "mdmids");
    }
}

