/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.request;

import com.envision.eeop.api.EnvisionRequest;
import com.envision.eeop.api.exception.EnvisionRuleException;
import com.envision.eeop.api.response.UserLoginResponse;
import com.envision.eeop.api.util.AES;
import com.envision.eeop.api.util.EnvisionHashMap;
import com.envision.eeop.api.util.RuleCheckUtils;
import java.util.Map;

public class UserLoginRequest
implements EnvisionRequest<UserLoginResponse> {
    private static final String API_METHOD = "/userService/login";
    private String name;
    private String password;
    private String passwordEncrypt;

    public UserLoginRequest() {
    }

    public UserLoginRequest(String name, String password) throws Exception {
        this.name = name;
        this.password = password;
        this.passwordEncrypt = AES.encrypt(password);
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public Map<String, String> getTextParams() {
        EnvisionHashMap txtParams = new EnvisionHashMap();
        txtParams.put("name", this.name);
        txtParams.put("password", this.passwordEncrypt);
        return txtParams;
    }

    @Override
    public Class<UserLoginResponse> getResponseClass() {
        return UserLoginResponse.class;
    }

    @Override
    public void check() throws EnvisionRuleException {
        RuleCheckUtils.checkNotEmpty(this.name, "name");
        RuleCheckUtils.checkNotEmpty(this.password, "password");
    }

    private boolean passwordCheckStrong(String password) {
        if (password == null || password.trim().length() == 0) {
            return false;
        }
        char[] pPsdChars = password.toCharArray();
        int numIndex = 0;
        int sLetterIndex = 0;
        int lLetterIndex = 0;
        int symbolIndex = 0;
        for (char pPsdChar : pPsdChars) {
            char ascll = pPsdChar;
            if (ascll >= '0' && ascll <= '9') {
                ++numIndex;
                continue;
            }
            if (ascll >= 'A' && ascll <= 'Z') {
                ++lLetterIndex;
                continue;
            }
            if (ascll >= 'a' && ascll <= 'z') {
                ++sLetterIndex;
                continue;
            }
            if (!(ascll >= '!' && ascll <= '/' || ascll >= ':' && ascll <= '@' || ascll >= '[' && ascll <= '`') && (ascll < '{' || ascll > '~')) continue;
            ++symbolIndex;
        }
        return numIndex >= 1 && sLetterIndex >= 1 && lLetterIndex >= 1 && symbolIndex >= true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) throws Exception {
        this.password = password;
        this.passwordEncrypt = AES.encrypt(password);
    }
}

