/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.response;

import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.domain.DeviceTemplate;
import com.envision.eeop.api.util.StringUtils;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttachedDeviceTemplatesGetResponse
extends EnvisionResponse {
    private static final long serialVersionUID = 562209201885192770L;
    @SerializedName(value="data")
    private Map<String, String> mdmToDeviceTemplateId;
    private Map<String, DeviceTemplate> deviceTemplates;

    public void setMdmToDeviceTemplateId(Map<String, String> mdmToDeviceTemplateId) {
        this.mdmToDeviceTemplateId = mdmToDeviceTemplateId;
    }

    public void setMdmToDeviceTemplateIdList(Map<String, List<String>> mdmToDeviceTemplateIds) {
        this.mdmToDeviceTemplateId = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : mdmToDeviceTemplateIds.entrySet()) {
            this.mdmToDeviceTemplateId.put(entry.getKey(), StringUtils.listToString(entry.getValue(), ','));
        }
    }

    public void setDeviceTemplates(Map<String, DeviceTemplate> deviceTemplates) {
        this.deviceTemplates = deviceTemplates;
    }

    public List<DeviceTemplate> getDeviceTemplateList(String mdmId) {
        ArrayList<DeviceTemplate> result = new ArrayList<DeviceTemplate>();
        if (this.mdmToDeviceTemplateId.containsKey(mdmId)) {
            String[] deviceTemplateIds;
            for (String deviceTemplateId : deviceTemplateIds = StringUtils.split(this.mdmToDeviceTemplateId.get(mdmId), ",")) {
                if (!this.deviceTemplates.containsKey(deviceTemplateId)) continue;
                result.add(this.deviceTemplates.get(deviceTemplateId));
            }
        }
        return result;
    }

    public DeviceTemplate getDeviceTemplate(String mdmId) {
        List<DeviceTemplate> deviceTemplates = this.getDeviceTemplateList(mdmId);
        if (!deviceTemplates.isEmpty()) {
            return deviceTemplates.iterator().next();
        }
        return null;
    }

    public Map<String, DeviceTemplate> getDeviceTemplates() {
        HashMap<String, DeviceTemplate> result = new HashMap<String, DeviceTemplate>();
        for (String mdmId : this.mdmToDeviceTemplateId.keySet()) {
            DeviceTemplate deviceTemplate = this.getDeviceTemplate(mdmId);
            if (deviceTemplate == null) continue;
            result.put(mdmId, deviceTemplate);
        }
        return result;
    }

    public Map<String, List<DeviceTemplate>> getDeviceTemplateLists() {
        HashMap<String, List<DeviceTemplate>> result = new HashMap<String, List<DeviceTemplate>>();
        for (String mdmId : this.mdmToDeviceTemplateId.keySet()) {
            List<DeviceTemplate> deviceTemplates = this.getDeviceTemplateList(mdmId);
            if (deviceTemplates.isEmpty()) continue;
            result.put(mdmId, this.getDeviceTemplateList(mdmId));
        }
        return result;
    }

    public String toString() {
        return "AttachedDeviceTemplatesGetResponse [mdmToDeviceTemplateId=" + this.mdmToDeviceTemplateId + ", deviceTemplates=" + this.deviceTemplates + "]";
    }
}

