/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.response;

import com.envision.eeop.api.EnvisionResponse;
import com.envision.eeop.api.domain.DomainInfo;
import com.envision.eeop.api.domain.DomainSchema;
import com.envision.eeop.api.util.StringUtils;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainSchemasGetResponseV2
extends EnvisionResponse {
    private static final long serialVersionUID = 5507674239653869373L;
    @SerializedName(value="data")
    private Map<String, String> mdmToDomainInfo;
    private Map<String, DomainInfo> domainInfo;

    public Map<String, DomainInfo> getDomainInfo() {
        HashMap<String, DomainInfo> result = new HashMap<String, DomainInfo>();
        for (Map.Entry<String, String> entry : this.mdmToDomainInfo.entrySet()) {
            String[] domainInfoIDs = StringUtils.split(entry.getValue(), ",");
            ArrayList<DomainInfo> domainInfos = new ArrayList<DomainInfo>();
            for (String domainInfoID : domainInfoIDs) {
                if (!this.domainInfo.containsKey(domainInfoID)) continue;
                domainInfos.add(this.domainInfo.get(domainInfoID));
            }
            if (domainInfos.isEmpty()) continue;
            result.put(entry.getKey(), DomainInfo.merge(domainInfos));
        }
        return result;
    }

    public Map<String, List<DomainSchema>> getDomainSchemas() {
        HashMap<String, List<DomainSchema>> result = new HashMap<String, List<DomainSchema>>();
        Map<String, DomainInfo> domainInfoMap = this.getDomainInfo();
        for (Map.Entry<String, DomainInfo> entry : domainInfoMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSchemas());
        }
        return result;
    }

    public void setMdmToDomainInfo(Map<String, String> mdmToDomainInfo) {
        this.mdmToDomainInfo = mdmToDomainInfo;
    }

    public void setMdmToDomainInfoList(Map<String, List<String>> mdmToDomainInfo) {
        this.mdmToDomainInfo = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : mdmToDomainInfo.entrySet()) {
            String cimObjectID = entry.getKey();
            String domainInfoKey = StringUtils.listToString(entry.getValue(), ',');
            this.mdmToDomainInfo.put(cimObjectID, domainInfoKey);
        }
    }

    public void setDomainInfo(Map<String, DomainInfo> domainInfo) {
        this.domainInfo = domainInfo;
    }
}

