/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.util;

import com.envision.eos.event.api.expression.Expression;
import com.envision.eos.event.api.expression.Filter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class EventJsonParser {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Expression.class, (Object)new ExpressionDeserializer()).registerTypeAdapter(Filter.class, (Object)new FilterDeserializer()).create();
    private static final String FILTER_PREFIX = "com.envision.eos.event.api.expression.";

    private EventJsonParser() {
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)gson.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return (T)gson.fromJson(json, typeOfT);
    }

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static String toJson(Object object, Type typeOfT) {
        return gson.toJson(object, typeOfT);
    }

    public static class ExpressionDeserializer
    implements JsonSerializer<Expression>,
    JsonDeserializer<Expression> {
        public Expression deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String type = ((JsonObject)json).get("type").getAsString();
                type = EventJsonParser.FILTER_PREFIX + type;
                Class<?> klass = Class.forName(type);
                return (Expression)context.deserialize((JsonElement)((JsonObject)json), klass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public JsonElement serialize(Expression src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement json = context.serialize((Object)src, src.getClass());
            return json;
        }
    }

    public static class FilterDeserializer
    implements JsonSerializer<Filter>,
    JsonDeserializer<Filter> {
        public Filter deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String type = ((JsonObject)json).get("type").getAsString();
                type = EventJsonParser.FILTER_PREFIX + type;
                Class<?> klass = Class.forName(type);
                return (Filter)context.deserialize((JsonElement)((JsonObject)json), klass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public JsonElement serialize(Filter src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement json = context.serialize((Object)src, src.getClass());
            return json;
        }
    }
}

