/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class SetUtils {
    protected static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static <E> List<E> difference(Collection<? extends E> set1, Collection<? extends E> set2) {
        SetUtils.checkNotNull(set1, "set1");
        SetUtils.checkNotNull(set2, "set2");
        HashSet<E> _set1 = new HashSet<E>(set1);
        HashSet<E> _set2 = new HashSet<E>(set2);
        ArrayList result = new ArrayList();
        for (Object e : _set1) {
            if (_set2.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> List<E> union(Collection<? extends E> set1, Collection<? extends E> set2) {
        SetUtils.checkNotNull(set1, "set1");
        SetUtils.checkNotNull(set2, "set2");
        List<? extends E> set2minus1 = SetUtils.difference(set2, set1);
        ArrayList<? extends E> result = new ArrayList<E>(new HashSet<E>(set1));
        result.addAll(set2minus1);
        return result;
    }
}

