/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign {
    private static Logger logger = LoggerFactory.getLogger(Sign.class);

    private Sign() {
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int twoHalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (twoHalfs++ < 1);
        }
        return buf.toString();
    }

    public static String makeString(String appKey, String secret, Map<String, String> paramMap) {
        Object[] keyArray = paramMap.keySet().toArray(new String[0]);
        Arrays.sort(keyArray);
        StringBuilder stringBuilder = new StringBuilder();
        if (appKey != null) {
            stringBuilder.append(appKey);
        }
        for (Object key : keyArray) {
            stringBuilder.append((String)key).append(paramMap.get(key));
        }
        stringBuilder.append(secret);
        return stringBuilder.toString();
    }

    public static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(data);
            bytes = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static byte[] encryptSHA(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            sha.update(data);
            bytes = sha.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static byte[] encryptHMAC(byte[] data, String key) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec sk = new SecretKeySpec(key.getBytes("UTF-8"), "HmacMD5");
            Mac mac = Mac.getInstance(sk.getAlgorithm());
            mac.init(sk);
            bytes = mac.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static String sign(String appKey, String secret, Map<String, String> paramMap, String type) {
        String sign = null;
        try {
            String codes = Sign.makeString(appKey, secret, paramMap);
            byte[] bytes = codes.getBytes("UTF-8");
            byte[] encrypt = type.equals("MD5") ? Sign.encryptMD5(bytes) : (type.equals("HmacMD5") ? Sign.encryptHMAC(bytes, secret) : Sign.encryptSHA(bytes));
            String hexStr = Sign.convertToHex(encrypt);
            sign = hexStr.toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            return new String("");
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
            return new String("");
        }
        return sign;
    }

    public static String sign(String appKey, String secret, Map<String, String> paramMap) {
        return Sign.sign(appKey, secret, paramMap, "SHA");
    }

    public static String sign(String secret, Map<String, String> paramMap) {
        return Sign.sign(null, secret, paramMap, "SHA");
    }
}

