/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.util;

import java.util.ArrayList;
import java.util.List;

public abstract class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = obj.toString();
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtils.isEmpty(value);
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!StringUtils.isEmpty(unicode)) {
            for (int i = 0; i < unicode.length(); ++i) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    public static String stripNonValidXMLCharacters(String input) {
        if (input == null || "".equals(input)) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static String listToString(List<String> stringList, String separator) {
        if (stringList == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean flag = false;
        for (String string : stringList) {
            if (flag) {
                result.append(separator);
            } else {
                flag = true;
            }
            result.append(string);
        }
        return result.toString();
    }

    public static String listToString(List<String> stringList, char separator) {
        return StringUtils.listToString(stringList, String.valueOf(separator));
    }

    public static String[] split(String line, String seperator) {
        if (line == null || seperator == null || seperator.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int pos1 = 0;
        while (true) {
            int pos2;
            if ((pos2 = line.indexOf(seperator, pos1)) < 0) break;
            list.add(line.substring(pos1, pos2));
            pos1 = pos2 + seperator.length();
        }
        list.add(line.substring(pos1));
        for (int i = list.size() - 1; i >= 0 && ((String)list.get(i)).length() == 0; --i) {
            list.remove(i);
        }
        return list.toArray(new String[0]);
    }
}

