/*
 * Decompiled with CFR 0.152.
 */
package com.envision.eeop.api.util;

import com.envision.eeop.api.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";

    private WebUtils() {
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = WebUtils.buildQuery(params, charset);
            try {
                conn = WebUtils.getConnection(WebUtils.buildGetUrl(url, query), METHOD_GET, ctype);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw e;
            }
            try {
                rsp = WebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String content, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = content;
            try {
                conn = WebUtils.getConnection(WebUtils.buildGetUrl(url, query), METHOD_GET, ctype);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw e;
            }
            try {
                rsp = WebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        logger.info("Do Post, Url & Params : " + url + "&" + query);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.doPost(url, ctype, content, connectTimeout, readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            try {
                conn = WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw e;
            }
            try {
                out = conn.getOutputStream();
                out.write(content);
                rsp = WebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = WebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return WebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return WebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = WebUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("User-Agent", "eeop-java");
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }
}

